/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.DefaultAggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;

@UnstableApi
public final class AggregationOptionsBuilder {
    @Nullable
    private EventExecutor executor;
    @Nullable
    private ByteBufAllocator alloc;
    private boolean cacheResult;
    private boolean preferCached = true;

    AggregationOptionsBuilder() {
    }

    public AggregationOptionsBuilder executor(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public AggregationOptionsBuilder cacheResult(boolean cache) {
        if (this.alloc != null) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.cacheResult = cache;
        return this;
    }

    @Deprecated
    public AggregationOptionsBuilder alloc(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        if (this.cacheResult) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.alloc = alloc;
        return this;
    }

    public AggregationOptionsBuilder usePooledObjects() {
        return this.usePooledObjects(ByteBufAllocator.DEFAULT);
    }

    public AggregationOptionsBuilder usePooledObjects(ByteBufAllocator alloc) {
        return this.usePooledObjects(Objects.requireNonNull(alloc, "alloc"), true);
    }

    public AggregationOptionsBuilder usePooledObjects(ByteBufAllocator alloc, boolean preferCached) {
        Objects.requireNonNull(alloc, "alloc");
        if (this.cacheResult) {
            throw new IllegalStateException("Can't cache pooled objects");
        }
        this.alloc = alloc;
        this.preferCached = preferCached;
        return this;
    }

    public AggregationOptions build() {
        return new DefaultAggregationOptions(this.executor, this.alloc, this.preferCached, this.cacheResult);
    }
}

