/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.retry.AbstractRetryingClient;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfig;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfigMapping;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryDecision;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRule;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleWithContent;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryingClientBuilder;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponseDuplicator;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.SplitHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogAccess;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.stream.AbortedStreamException;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.client.AggregatedHttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientPendingThrowableUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.TruncatingHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DateFormatter;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryingClient
extends AbstractRetryingClient<HttpRequest, HttpResponse>
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryingClient.class);
    private final boolean useRetryAfter;

    public static RetryingClientBuilder builder(RetryConfig<HttpResponse> retryConfig) {
        return new RetryingClientBuilder(retryConfig);
    }

    public static RetryingClientBuilder builder(RetryRule retryRule) {
        return new RetryingClientBuilder(RetryConfig.builder0(retryRule).build());
    }

    public static RetryingClientBuilder builder(RetryRuleWithContent<HttpResponse> retryRuleWithContent) {
        return new RetryingClientBuilder(RetryConfig.builder0(retryRuleWithContent).build());
    }

    public static RetryingClientBuilder builder(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxContentLength) {
        Preconditions.checkArgument(maxContentLength > 0, "maxContentLength: %s (expected: > 0)", maxContentLength);
        return new RetryingClientBuilder(RetryConfig.builder0(retryRuleWithContent).maxContentLength(maxContentLength).build());
    }

    public static RetryingClientBuilder builderWithMapping(RetryConfigMapping<HttpResponse> mapping) {
        return new RetryingClientBuilder(mapping);
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule) {
        return RetryingClient.builder(retryRule).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent) {
        return RetryingClient.builder(retryRuleWithContent).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule, int maxTotalAttempts) {
        return RetryingClient.builder(retryRule).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxTotalAttempts) {
        return RetryingClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingClient.builder(retryRule).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryConfig<HttpResponse> retryConfig) {
        return RetryingClient.builder(retryConfig).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecoratorWithMapping(RetryConfigMapping<HttpResponse> mapping) {
        return RetryingClient.builderWithMapping(mapping).newDecorator();
    }

    RetryingClient(HttpClient delegate, RetryConfigMapping<HttpResponse> mapping, @Nullable RetryConfig<HttpResponse> retryConfig, boolean useRetryAfter) {
        super(delegate, mapping, retryConfig);
        this.useRetryAfter = useRetryAfter;
    }

    @Override
    protected HttpResponse doExecute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse res = HttpResponse.of(responseFuture, (EventExecutor)ctx.eventLoop());
        if (ctx.exchangeType().isRequestStreaming()) {
            HttpRequestDuplicator reqDuplicator = req.toDuplicator(ctx.eventLoop().withoutContext(), 0L);
            this.doExecute0(ctx, reqDuplicator, req, res, responseFuture);
        } else {
            req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), ctx.eventLoop())).handle((agg, cause) -> {
                if (cause != null) {
                    RetryingClient.handleException(ctx, null, responseFuture, cause, true);
                } else {
                    AggregatedHttpRequestDuplicator reqDuplicator = new AggregatedHttpRequestDuplicator((AggregatedHttpRequest)agg);
                    this.doExecute0(ctx, reqDuplicator, req, res, responseFuture);
                }
                return null;
            });
        }
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future) {
        HttpResponse response;
        ClientRequestContext derivedCtx;
        HttpRequest duplicateReq;
        boolean initialAttempt;
        int totalAttempts = RetryingClient.getTotalAttempts(ctx);
        boolean bl = initialAttempt = totalAttempts <= 1;
        if (originalReq.whenComplete().isCompletedExceptionally()) {
            originalReq.whenComplete().handle((unused, cause) -> {
                RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, initialAttempt);
                return null;
            });
            return;
        }
        if (returnedRes.isComplete()) {
            returnedRes.whenComplete().handle((result, cause) -> {
                Throwable abortCause = cause != null ? cause : AbortedStreamException.get();
                RetryingClient.handleException(ctx, rootReqDuplicator, future, abortCause, initialAttempt);
                return null;
            });
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingClient.handleException(ctx, rootReqDuplicator, future, ResponseTimeoutException.get(), initialAttempt);
            return;
        }
        if (initialAttempt) {
            duplicateReq = rootReqDuplicator.duplicate();
        } else {
            RequestHeadersBuilder newHeaders = originalReq.headers().toBuilder();
            newHeaders.setInt(ARMERIA_RETRY_COUNT, totalAttempts - 1);
            duplicateReq = rootReqDuplicator.duplicate(newHeaders.build());
        }
        try {
            derivedCtx = RetryingClient.newDerivedContext(ctx, duplicateReq, ctx.rpcRequest(), initialAttempt);
        }
        catch (Throwable t) {
            RetryingClient.handleException(ctx, rootReqDuplicator, future, t, initialAttempt);
            return;
        }
        HttpRequest ctxReq = derivedCtx.request();
        assert (ctxReq != null);
        ClientRequestContextExtension ctxExtension = derivedCtx.as(ClientRequestContextExtension.class);
        if (!initialAttempt && ctxExtension != null && derivedCtx.endpoint() == null) {
            ClientPendingThrowableUtil.removePendingThrowable(derivedCtx);
            response = ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctxExtension, HttpResponse::of, (context, cause) -> HttpResponse.ofFailure(cause), ctxReq, false);
        } else {
            response = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> HttpResponse.ofFailure(cause), ctxReq, false);
        }
        RetryConfig<HttpResponse> config = this.mappedRetryConfig(ctx);
        if (!ctx.exchangeType().isResponseStreaming() || config.requiresResponseTrailers()) {
            response.aggregate().handle((aggregated, cause) -> {
                if (cause != null) {
                    derivedCtx.logBuilder().endRequest((Throwable)cause);
                    derivedCtx.logBuilder().endResponse((Throwable)cause);
                    this.handleResponseWithoutContent(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, HttpResponse.ofFailure(cause), (Throwable)cause);
                } else {
                    RetryingClient.completeLogIfBytesNotTransferred(aggregated, derivedCtx);
                    derivedCtx.log().whenAvailable(RequestLogProperty.RESPONSE_END_TIME).thenRun(() -> this.handleAggregatedResponse(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, (AggregatedHttpResponse)aggregated));
                }
                return null;
            });
        } else {
            this.handleStreamingResponse(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, response);
        }
    }

    private void handleResponseWithoutContent(RetryConfig<HttpResponse> config, ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, ClientRequestContext derivedCtx, HttpResponse response, @Nullable Throwable responseCause) {
        if (responseCause != null) {
            responseCause = Exceptions.peel(responseCause);
        }
        try {
            RetryRule retryRule = RetryingClient.retryRule(config);
            CompletionStage<RetryDecision> f = retryRule.shouldRetry(derivedCtx, responseCause);
            f.handle((decision, shouldRetryCause) -> {
                RetryingClient.warnIfExceptionIsRaised(retryRule, shouldRetryCause);
                this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, response);
                return null;
            });
        }
        catch (Throwable cause) {
            response.abort();
            RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, false);
        }
    }

    private void handleStreamingResponse(RetryConfig<HttpResponse> retryConfig, ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, ClientRequestContext derivedCtx, HttpResponse response) {
        SplitHttpResponse splitResponse = response.split();
        splitResponse.headers().handle((headers, headersCause) -> {
            RequestLog log;
            Throwable responseCause = headersCause == null ? ((log = derivedCtx.log().getIfAvailable(RequestLogProperty.RESPONSE_CAUSE)) != null ? log.responseCause() : null) : Exceptions.peel(headersCause);
            RetryingClient.completeLogIfBytesNotTransferred(response, headers, derivedCtx, responseCause);
            derivedCtx.log().whenAvailable(RequestLogProperty.RESPONSE_HEADERS).thenRun(() -> {
                if (retryConfig.needsContentInRule() && responseCause == null) {
                    HttpResponse response0 = splitResponse.unsplit();
                    HttpResponseDuplicator duplicator = response0.toDuplicator(derivedCtx.eventLoop().withoutContext(), derivedCtx.maxResponseLength());
                    try {
                        TruncatingHttpResponse truncatingHttpResponse = new TruncatingHttpResponse(duplicator.duplicate(), retryConfig.maxContentLength());
                        HttpResponse duplicated = duplicator.duplicate();
                        duplicator.close();
                        RetryRuleWithContent<TruncatingHttpResponse> ruleWithContent = retryConfig.retryRuleWithContent();
                        assert (ruleWithContent != null);
                        ruleWithContent.shouldRetry(derivedCtx, truncatingHttpResponse, null).handle((decision, cause) -> {
                            RetryingClient.warnIfExceptionIsRaised(ruleWithContent, cause);
                            truncatingHttpResponse.abort();
                            this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, duplicated);
                            return null;
                        });
                    }
                    catch (Throwable cause2) {
                        duplicator.abort(cause2);
                        RetryingClient.handleException(ctx, rootReqDuplicator, future, cause2, false);
                    }
                } else {
                    HttpResponse response0;
                    if (responseCause != null) {
                        splitResponse.body().abort(responseCause);
                        response0 = HttpResponse.ofFailure(responseCause);
                    } else {
                        response0 = splitResponse.unsplit();
                    }
                    this.handleResponseWithoutContent(retryConfig, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, response0, responseCause);
                }
            });
            return null;
        });
    }

    private void handleAggregatedResponse(RetryConfig<HttpResponse> retryConfig, ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, ClientRequestContext derivedCtx, AggregatedHttpResponse aggregatedRes) {
        if (retryConfig.needsContentInRule()) {
            RetryRuleWithContent<HttpResponse> ruleWithContent = retryConfig.retryRuleWithContent();
            assert (ruleWithContent != null);
            try {
                ruleWithContent.shouldRetry(derivedCtx, aggregatedRes.toHttpResponse(), null).handle((decision, cause) -> {
                    RetryingClient.warnIfExceptionIsRaised(ruleWithContent, cause);
                    this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, aggregatedRes.toHttpResponse());
                    return null;
                });
            }
            catch (Throwable cause2) {
                RetryingClient.handleException(ctx, rootReqDuplicator, future, cause2, false);
            }
            return;
        }
        this.handleResponseWithoutContent(retryConfig, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, aggregatedRes.toHttpResponse(), null);
    }

    private static void completeLogIfBytesNotTransferred(AggregatedHttpResponse response, ClientRequestContext ctx) {
        if (!ctx.log().isAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME)) {
            RequestLogBuilder logBuilder = ctx.logBuilder();
            logBuilder.endRequest();
            logBuilder.responseHeaders(response.headers());
            if (!response.trailers().isEmpty()) {
                logBuilder.responseTrailers(response.trailers());
            }
            logBuilder.endResponse();
        }
    }

    private static void completeLogIfBytesNotTransferred(HttpResponse response, @Nullable ResponseHeaders headers, ClientRequestContext ctx, @Nullable Throwable responseCause) {
        if (!ctx.log().isAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME)) {
            RequestLogBuilder logBuilder = ctx.logBuilder();
            if (responseCause != null) {
                logBuilder.endRequest(responseCause);
                logBuilder.endResponse(responseCause);
            } else {
                logBuilder.endRequest();
                if (headers != null) {
                    logBuilder.responseHeaders(headers);
                }
                response.whenComplete().handle((unused, cause) -> {
                    if (cause != null) {
                        logBuilder.endResponse((Throwable)cause);
                    } else {
                        logBuilder.endResponse();
                    }
                    return null;
                });
            }
        }
    }

    private static void warnIfExceptionIsRaised(Object retryRule, @Nullable Throwable cause) {
        if (cause != null) {
            logger.warn("Unexpected exception is raised from {}.", retryRule, (Object)cause);
        }
    }

    private static void handleException(ClientRequestContext ctx, @Nullable HttpRequestDuplicator rootReqDuplicator, CompletableFuture<HttpResponse> future, Throwable cause, boolean endRequestLog) {
        future.completeExceptionally(cause);
        if (rootReqDuplicator != null) {
            rootReqDuplicator.abort(cause);
        }
        if (endRequestLog) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }

    private void handleRetryDecision(@Nullable RetryDecision decision, ClientRequestContext ctx, ClientRequestContext derivedCtx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, HttpResponse originalRes) {
        long millisAfter;
        long nextDelay;
        Backoff backoff;
        Backoff backoff2 = backoff = decision != null ? decision.backoff() : null;
        if (backoff != null && (nextDelay = this.getNextDelay(ctx, backoff, millisAfter = this.useRetryAfter ? RetryingClient.getRetryAfterMillis(derivedCtx) : -1L)) >= 0L) {
            RetryingClient.abortResponse(originalRes, derivedCtx);
            RetryingClient.scheduleNextRetry(ctx, cause -> RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, false), () -> this.doExecute0(ctx, rootReqDuplicator, originalReq, returnedRes, future), nextDelay);
            return;
        }
        RetryingClient.onRetryingComplete(ctx);
        future.complete(originalRes);
        rootReqDuplicator.close();
    }

    private static void abortResponse(HttpResponse originalRes, ClientRequestContext derivedCtx) {
        RequestLogBuilder logBuilder = derivedCtx.logBuilder();
        logBuilder.responseContent(null, null);
        logBuilder.responseContentPreview(null);
        originalRes.abort();
    }

    private static long getRetryAfterMillis(ClientRequestContext ctx) {
        String value;
        RequestLogAccess log = ctx.log();
        RequestLog requestLog = log.getIfAvailable(RequestLogProperty.RESPONSE_HEADERS);
        String string = value = requestLog != null ? requestLog.responseHeaders().get(HttpHeaderNames.RETRY_AFTER) : null;
        if (value != null) {
            try {
                return Duration.ofSeconds(Integer.parseInt(value)).toMillis();
            }
            catch (Exception exception) {
                try {
                    Date date = DateFormatter.parseHttpDate(value);
                    if (date != null) {
                        return date.getTime() - System.currentTimeMillis();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                logger.debug("The retryAfter: {}, from the server is neither an HTTP date nor a second.", (Object)value);
            }
        }
        return -1L;
    }

    private static RetryRule retryRule(RetryConfig<HttpResponse> retryConfig) {
        if (retryConfig.needsContentInRule()) {
            return retryConfig.fromRetryRuleWithContent();
        }
        RetryRule rule = retryConfig.retryRule();
        assert (rule != null);
        return rule;
    }
}

