/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.AbstractBackoff;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

final class FixedBackoff
extends AbstractBackoff {
    static final Backoff NO_DELAY = new FixedBackoff(0L);
    private final long delayMillis;

    FixedBackoff(long delayMillis) {
        Preconditions.checkArgument(delayMillis >= 0L, "delayMillis: %s (expected: >= 0)", delayMillis);
        this.delayMillis = delayMillis;
    }

    @Override
    protected long doNextDelayMillis(int numAttemptsSoFar) {
        return this.delayMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("delayMillis", this.delayMillis).toString();
    }
}

