/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

final class BackoffSpec {
    private static final Splitter OPTION_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final Splitter VALUE_SPLITTER = Splitter.on(':').trimResults();
    private static final List<String> ORDINALS = ImmutableList.of("first", "second", "third");
    private static final long DEFAULT_INITIAL_DELAY_MILLIS = 200L;
    private static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    private static final double DEFAULT_MULTIPLIER = 2.0;
    private static final double DEFAULT_MAX_JITTER_RATE = 0.2;
    private final String specification;
    @Nullable
    private BaseOption baseOption;
    private boolean jitterConfigured;
    private boolean maxAttemptsConfigured;
    long initialDelayMillis = 200L;
    long maxDelayMillis = 10000L;
    double multiplier = 2.0;
    double minJitterRate = -0.2;
    double maxJitterRate = 0.2;
    int maxAttempts;
    long fixedDelayMillis;
    long randomMinDelayMillis;
    long randomMaxDelayMillis;

    static BackoffSpec parse(String specification) {
        Objects.requireNonNull(specification, "specification");
        BackoffSpec spec = new BackoffSpec(specification);
        for (String option : OPTION_SPLITTER.split(specification)) {
            spec.parseOption(option);
        }
        return spec;
    }

    private BackoffSpec(String specification) {
        this.specification = specification;
    }

    private void parseOption(String option) {
        if (option.isEmpty()) {
            return;
        }
        List<String> keyAndValues = KEY_VALUE_SPLITTER.splitToList(option);
        Preconditions.checkArgument(keyAndValues.size() == 2, "option '%s' (expected 'key=value1:value2...')", (Object)option);
        this.configure(keyAndValues.get(0), keyAndValues.get(1));
    }

    private void configure(String key, String values) {
        switch (Ascii.toLowerCase(key)) {
            case "exponential": {
                this.exponential(key, values);
                return;
            }
            case "fibonacci": {
                this.fibonacci(key, values);
                return;
            }
            case "fixed": {
                this.fixed(key, values);
                return;
            }
            case "random": {
                this.randomBackoff(key, values);
                return;
            }
            case "jitter": {
                this.jitter(key, values);
                return;
            }
            case "maxattempts": {
                this.maxAttempts(key, values);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown key " + key);
    }

    private void exponential(String key, String exponentialValues) {
        this.checkBaseBackoffConfigured();
        this.baseOption = BaseOption.exponential;
        List<String> values = VALUE_SPLITTER.splitToList(exponentialValues);
        Preconditions.checkArgument(values.size() == 2 || values.size() == 3, "the number of values for '%s' should be 2 or 3. input '%s'", (Object)key, (Object)exponentialValues);
        this.initialDelayMillis = BackoffSpec.parseLong(key, values.get(0), ORDINALS.get(0));
        BackoffSpec.checkNegative(key, this.initialDelayMillis, ORDINALS.get(0));
        this.maxDelayMillis = BackoffSpec.parseLong(key, values.get(1), ORDINALS.get(1));
        BackoffSpec.checkNegative(key, this.maxDelayMillis, ORDINALS.get(1));
        if (this.initialDelayMillis > this.maxDelayMillis) {
            long temp = this.initialDelayMillis;
            this.initialDelayMillis = this.maxDelayMillis;
            this.maxDelayMillis = temp;
        }
        if (values.size() == 3) {
            this.multiplier = BackoffSpec.parseDouble(key, values.get(2), ORDINALS.get(2));
        }
    }

    private void checkBaseBackoffConfigured() {
        Preconditions.checkArgument(this.baseOption == null, "%s backoff is already set.", (Object)this.baseOption);
    }

    private static void checkNegative(String key, long value, String ordinal) {
        Preconditions.checkArgument(value >= 0L, "%s parameter for %s must be a positive value. input: %s", (Object)ordinal, (Object)key, (Object)value);
    }

    private void fibonacci(String key, String fibonacciValues) {
        this.checkBaseBackoffConfigured();
        this.baseOption = BaseOption.fibonacci;
        List<String> values = VALUE_SPLITTER.splitToList(fibonacciValues);
        Preconditions.checkArgument(values.size() == 2, "the number of values for '%s' should be 2. input '%s'", (Object)key, (Object)fibonacciValues);
        this.initialDelayMillis = BackoffSpec.parseLong(key, values.get(0), ORDINALS.get(0));
        BackoffSpec.checkNegative(key, this.initialDelayMillis, ORDINALS.get(0));
        this.maxDelayMillis = BackoffSpec.parseLong(key, values.get(1), ORDINALS.get(1));
        BackoffSpec.checkNegative(key, this.maxDelayMillis, ORDINALS.get(1));
        if (this.initialDelayMillis > this.maxDelayMillis) {
            long temp = this.initialDelayMillis;
            this.initialDelayMillis = this.maxDelayMillis;
            this.maxDelayMillis = temp;
        }
    }

    private void fixed(String key, String value) {
        this.checkBaseBackoffConfigured();
        this.baseOption = BaseOption.fixed;
        this.fixedDelayMillis = BackoffSpec.parseLong(key, value, ORDINALS.get(0));
        BackoffSpec.checkNegative(key, this.fixedDelayMillis, ORDINALS.get(0));
    }

    private void randomBackoff(String key, String randomValues) {
        this.checkBaseBackoffConfigured();
        this.baseOption = BaseOption.random;
        List<String> values = VALUE_SPLITTER.splitToList(randomValues);
        Preconditions.checkArgument(values.size() == 2, "the number of values for '%s' should be 2. input '%s'", (Object)key, (Object)randomValues);
        this.randomMinDelayMillis = BackoffSpec.parseLong(key, values.get(0), ORDINALS.get(0));
        BackoffSpec.checkNegative(key, this.randomMinDelayMillis, ORDINALS.get(0));
        this.randomMaxDelayMillis = BackoffSpec.parseLong(key, values.get(1), ORDINALS.get(1));
        BackoffSpec.checkNegative(key, this.randomMaxDelayMillis, ORDINALS.get(1));
        if (this.randomMinDelayMillis > this.randomMaxDelayMillis) {
            long temp = this.randomMinDelayMillis;
            this.randomMinDelayMillis = this.randomMaxDelayMillis;
            this.randomMaxDelayMillis = temp;
        }
    }

    private void jitter(String key, String jitterValues) {
        Preconditions.checkArgument(!this.jitterConfigured, "jitter parameters are already set. minJitterRate: %s, maxJitterRate: %s", (Object)this.minJitterRate, (Object)this.maxJitterRate);
        this.jitterConfigured = true;
        List<String> values = VALUE_SPLITTER.splitToList(jitterValues);
        Preconditions.checkArgument(values.size() == 1 || values.size() == 2, "the number of values for '%s' should be 1 or 2. input '%s'", (Object)key, (Object)jitterValues);
        if (values.size() == 1) {
            double jitterRate = BackoffSpec.parseDouble(key, values.get(0), ORDINALS.get(0));
            BackoffSpec.checkDoubleBetween(key, jitterRate, 0.0, 1.0, ORDINALS.get(0));
            this.minJitterRate = jitterRate * -1.0;
            this.maxJitterRate = jitterRate;
        } else {
            this.minJitterRate = BackoffSpec.parseDouble(key, values.get(0), ORDINALS.get(0));
            BackoffSpec.checkDoubleBetween(key, this.minJitterRate, -1.0, 1.0, ORDINALS.get(0));
            this.maxJitterRate = BackoffSpec.parseDouble(key, values.get(1), ORDINALS.get(1));
            BackoffSpec.checkDoubleBetween(key, this.maxJitterRate, -1.0, 1.0, ORDINALS.get(1));
            if (this.minJitterRate > this.maxJitterRate) {
                double temp = this.minJitterRate;
                this.minJitterRate = this.maxJitterRate;
                this.maxJitterRate = temp;
            }
        }
    }

    private static void checkDoubleBetween(String key, double value, double min, double max, String ordinal) {
        Preconditions.checkArgument(min <= value && value <= max, "%s parameter for %s must be >= %s and <= %s. input: %s", ordinal, key, min, max, value);
    }

    private void maxAttempts(String key, String value) {
        Preconditions.checkArgument(!this.maxAttemptsConfigured, "maxAttempts parameters is already set. maxAttempts: %s", this.maxAttempts);
        this.maxAttemptsConfigured = true;
        this.maxAttempts = BackoffSpec.parseInt(key, value);
        BackoffSpec.checkNegative(key, this.maxAttempts, ORDINALS.get(0));
    }

    private static long parseLong(String key, String value, String ordinal) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s parameter for %s was set to %s, must be a long", ordinal, key, value), e);
        }
    }

    private static double parseDouble(String key, String value, String ordinal) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s parameter for %s was set to %s, must be a double", ordinal, key, value), e);
        }
    }

    private static int parseInt(String key, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s was set to %s, must be an integer", key, value), e);
        }
    }

    Backoff build() {
        Backoff backoff = this.baseOption == BaseOption.fixed ? Backoff.fixed(this.fixedDelayMillis) : (this.baseOption == BaseOption.random ? Backoff.random(this.randomMinDelayMillis, this.randomMaxDelayMillis) : (this.baseOption == BaseOption.fibonacci ? Backoff.fibonacci(this.initialDelayMillis, this.maxDelayMillis) : Backoff.exponential(this.initialDelayMillis, this.maxDelayMillis, this.multiplier)));
        backoff = backoff.withJitter(this.minJitterRate, this.maxJitterRate);
        if (this.maxAttemptsConfigured) {
            backoff = backoff.withMaxAttempts(this.maxAttempts);
        }
        return backoff;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).add("specification", this.specification);
        if (this.baseOption == BaseOption.fixed) {
            stringHelper.add("fixedDelayMillis", this.fixedDelayMillis);
        } else if (this.baseOption == BaseOption.random) {
            stringHelper.add("randomMinDelayMillis", this.randomMinDelayMillis).add("randomMaxDelayMillis", this.randomMaxDelayMillis);
        } else {
            stringHelper.add("initialDelayMillis", this.initialDelayMillis).add("maxDelayMillis", this.maxDelayMillis).add("multiplier", this.multiplier);
        }
        stringHelper.add("minJitterRate", this.minJitterRate).add("maxJitterRate", this.maxJitterRate);
        if (this.maxAttemptsConfigured) {
            stringHelper.add("maxAttempts", this.maxAttempts);
        }
        return stringHelper.toString();
    }

    private static enum BaseOption {
        exponential,
        fibonacci,
        fixed,
        random;

    }
}

