/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.proxy;

import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyConfig;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class Socks4ProxyConfig
extends ProxyConfig {
    private final InetSocketAddress proxyAddress;
    @Nullable
    private final String username;

    Socks4ProxyConfig(InetSocketAddress proxyAddress, @Nullable String username) {
        this.proxyAddress = proxyAddress;
        this.username = username;
    }

    @Override
    public InetSocketAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    public ProxyType proxyType() {
        return ProxyType.SOCKS4;
    }

    @Override
    public ProxyConfig withProxyAddress(InetSocketAddress newProxyAddress) {
        return new Socks4ProxyConfig(newProxyAddress, this.username);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Socks4ProxyConfig)) {
            return false;
        }
        Socks4ProxyConfig that = (Socks4ProxyConfig)o;
        return this.proxyAddress.equals(that.proxyAddress) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.username);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("proxyType", (Object)this.proxyType()).add("proxyAddress", this.proxyAddress()).add("username", this.username()).toString();
    }
}

