/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.limit;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.limit.ConcurrencyLimitBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;

@FunctionalInterface
@UnstableApi
public interface ConcurrencyLimit {
    public static ConcurrencyLimit of(int maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    @UnstableApi
    public static ConcurrencyLimit of(IntSupplier maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    public static ConcurrencyLimitBuilder builder(int maxConcurrency) {
        Preconditions.checkArgument(maxConcurrency >= 0, "maxConcurrency: %s (expected: >= 0)", maxConcurrency);
        return new ConcurrencyLimitBuilder(maxConcurrency == Integer.MAX_VALUE ? 0 : maxConcurrency);
    }

    @UnstableApi
    public static ConcurrencyLimitBuilder builder(IntSupplier maxConcurrency) {
        Objects.requireNonNull(maxConcurrency, "maxConcurrency");
        return new ConcurrencyLimitBuilder(maxConcurrency);
    }

    public CompletableFuture<SafeCloseable> acquire(ClientRequestContext var1);
}

