/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck;

import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.DynamicEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.DefaultHealthCheckerContext;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckContextGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupMetrics;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.endpoint.EndpointAttributeKeys;
import io.opentelemetry.testing.internal.armeria.internal.common.util.CollectionUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.futures.CompletableFutures;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckedEndpointGroup
extends DynamicEndpointGroup {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckedEndpointGroup.class);
    final EndpointGroup delegate;
    private final long initialSelectionTimeoutMillis;
    private final long selectionTimeoutMillis;
    private final SessionProtocol protocol;
    private final int port;
    private final Backoff retryBackoff;
    private final ClientOptions clientOptions;
    private final Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory;
    final HealthCheckStrategy healthCheckStrategy;
    private final Predicate<Endpoint> healthCheckedEndpointPredicate;
    private final ReentrantLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Deque<HealthCheckContextGroup> contextGroupChain = new ArrayDeque<HealthCheckContextGroup>(4);
    final Map<Endpoint, Endpoint> cachedEndpoints = new ConcurrentHashMap<Endpoint, Endpoint>();
    private volatile boolean initialized;

    public static HealthCheckedEndpointGroup of(EndpointGroup delegate, String path) {
        return HealthCheckedEndpointGroup.builder(delegate, path).build();
    }

    public static HealthCheckedEndpointGroupBuilder builder(EndpointGroup delegate, String path) {
        return new HealthCheckedEndpointGroupBuilder(delegate, path);
    }

    HealthCheckedEndpointGroup(EndpointGroup delegate, boolean allowEmptyEndpoints, long initialSelectionTimeoutMillis, long selectionTimeoutMillis, SessionProtocol protocol, int port, Backoff retryBackoff, ClientOptions clientOptions, Function<? super HealthCheckerContext, ? extends AsyncCloseable> checkerFactory, HealthCheckStrategy healthCheckStrategy, Predicate<Endpoint> healthCheckedEndpointPredicate) {
        super(Objects.requireNonNull(delegate, "delegate").selectionStrategy(), allowEmptyEndpoints);
        this.delegate = delegate;
        this.initialSelectionTimeoutMillis = initialSelectionTimeoutMillis;
        this.selectionTimeoutMillis = selectionTimeoutMillis;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.port = port;
        this.retryBackoff = Objects.requireNonNull(retryBackoff, "retryBackoff");
        this.clientOptions = Objects.requireNonNull(clientOptions, "clientOptions");
        this.checkerFactory = Objects.requireNonNull(checkerFactory, "checkerFactory");
        this.healthCheckStrategy = Objects.requireNonNull(healthCheckStrategy, "healthCheckStrategy");
        this.healthCheckedEndpointPredicate = Objects.requireNonNull(healthCheckedEndpointPredicate, "healthCheckedEndpointPredicate");
        clientOptions.factory().whenClosed().thenRun(this::closeAsync);
        delegate.addListener(this::setCandidates, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCandidates(List<Endpoint> endpoints) {
        List<Endpoint> candidates = this.healthCheckStrategy.select(endpoints);
        HashMap<Endpoint, DefaultHealthCheckerContext> contexts = new HashMap<Endpoint, DefaultHealthCheckerContext>(candidates.size());
        this.lock.lock();
        try {
            for (Endpoint endpoint : candidates) {
                if (contexts.containsKey(endpoint)) continue;
                DefaultHealthCheckerContext context = this.findContext(endpoint);
                if (context != null) {
                    contexts.put(endpoint, context.retain());
                    continue;
                }
                contexts.computeIfAbsent(endpoint, this::newCheckerContext);
            }
            HealthCheckContextGroup contextGroup = new HealthCheckContextGroup(contexts, candidates, this.checkerFactory);
            this.contextGroupChain.add(contextGroup);
            contextGroup.initialize();
            contextGroup.whenInitialized().handle((unused, cause) -> {
                if (cause != null && !this.initialized && logger.isWarnEnabled()) {
                    logger.warn("The first health check failed for all endpoints. numCandidates: {} candidates: {}", new Object[]{candidates.size(), CollectionUtil.truncate(candidates, 10), cause});
                }
                this.initialized = true;
                this.destroyOldContexts(contextGroup);
                this.setEndpoints0(this.allHealthyEndpoints());
                return null;
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    Queue<HealthCheckContextGroup> contextGroupChain() {
        return this.contextGroupChain;
    }

    List<Endpoint> allHealthyEndpoints() {
        this.lock.lock();
        try {
            List<Endpoint> list = this.allEndpoints().stream().filter(this.healthCheckedEndpointPredicate).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Endpoint> allEndpoints() {
        this.lock.lock();
        try {
            HealthCheckContextGroup newGroup = this.contextGroupChain.peekLast();
            if (newGroup == null) {
                ImmutableList<Endpoint> immutableList = ImmutableList.of();
                return immutableList;
            }
            ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>(newGroup.candidates());
            HashSet<Endpoint> addedEndpoints = new HashSet<Endpoint>(newGroup.candidates());
            for (HealthCheckContextGroup oldGroup : this.contextGroupChain) {
                if (oldGroup == newGroup) break;
                for (Endpoint candidate : oldGroup.candidates()) {
                    if (!addedEndpoints.add(candidate)) continue;
                    allEndpoints.add(candidate);
                }
            }
            ArrayList<Endpoint> arrayList = allEndpoints;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DefaultHealthCheckerContext findContext(Endpoint endpoint) {
        this.lock.lock();
        try {
            for (HealthCheckContextGroup contextGroup : this.contextGroupChain) {
                DefaultHealthCheckerContext context = contextGroup.contexts().get(endpoint);
                if (context == null) continue;
                DefaultHealthCheckerContext defaultHealthCheckerContext = context;
                return defaultHealthCheckerContext;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private DefaultHealthCheckerContext newCheckerContext(Endpoint endpoint) {
        return new DefaultHealthCheckerContext(endpoint, this.port, this.protocol, this.clientOptions, this.retryBackoff, this::updateHealth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyOldContexts(HealthCheckContextGroup contextGroup) {
        this.lock.lock();
        try {
            if (!this.contextGroupChain.contains(contextGroup)) {
                return;
            }
            Iterator<HealthCheckContextGroup> it = this.contextGroupChain.iterator();
            while (it.hasNext()) {
                HealthCheckContextGroup maybeOldGroup = it.next();
                if (maybeOldGroup == contextGroup) {
                    break;
                }
                for (DefaultHealthCheckerContext context : maybeOldGroup.contexts().values()) {
                    context.release();
                }
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateHealth(Endpoint endpoint, boolean health) {
        Endpoint cached;
        if (this.isClosing()) {
            return;
        }
        boolean updated = health && this.findContext(endpoint) != null ? (cached = this.cachedEndpoints.put(endpoint, endpoint)) == null || !EndpointAttributeKeys.equalHealthCheckAttributes(cached, endpoint) : this.cachedEndpoints.remove(endpoint, endpoint);
        if (updated && this.initialized) {
            this.setEndpoints0(this.allHealthyEndpoints());
        }
    }

    private void setEndpoints0(List<Endpoint> endpoints) {
        if (this.isClosing()) {
            return;
        }
        this.setEndpoints(endpoints);
    }

    @Override
    public long selectionTimeoutMillis() {
        return this.initialized ? this.selectionTimeoutMillis : this.initialSelectionTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseAsync(CompletableFuture<?> future) {
        CompletableFuture stopFutures;
        this.lock.lock();
        try {
            ImmutableList.Builder completionFutures = ImmutableList.builder();
            for (HealthCheckContextGroup group : this.contextGroupChain) {
                for (DefaultHealthCheckerContext context : group.contexts().values()) {
                    try {
                        CompletableFuture<?> closeFuture = context.release();
                        if (closeFuture == null) continue;
                        completionFutures.add(closeFuture.exceptionally(cause -> {
                            logger.warn("Failed to stop a health checker for: {}", (Object)context.endpoint(), cause);
                            return null;
                        }));
                    }
                    catch (Exception ex) {
                        logger.warn("Unexpected exception while closing a health checker for: {}", (Object)context.endpoint(), (Object)ex);
                    }
                }
            }
            stopFutures = CompletableFutures.allAsList(completionFutures.build());
        }
        finally {
            this.lock.unlock();
        }
        ((CompletableFuture)stopFutures.handle((unused1, unused2) -> {
            this.lock.lock();
            try {
                this.contextGroupChain.clear();
            }
            finally {
                this.lock.unlock();
            }
            return this.delegate.closeAsync();
        })).handle((unused1, unused2) -> future.complete(null));
    }

    public MeterBinder newMeterBinder(String groupName) {
        return this.newMeterBinder(new MeterIdPrefix("armeria.client.endpoint.group", "name", groupName));
    }

    public MeterBinder newMeterBinder(MeterIdPrefix idPrefix) {
        return new HealthCheckedEndpointGroupMetrics(this, idPrefix);
    }

    @Override
    public String toString() {
        List<Endpoint> endpoints = this.endpoints();
        List<Endpoint> delegateEndpoints = this.delegate.endpoints();
        return MoreObjects.toStringHelper(this).add("endpoints", CollectionUtil.truncate(endpoints, 10)).add("numEndpoints", endpoints.size()).add("candidates", CollectionUtil.truncate(delegateEndpoints, 10)).add("numCandidates", delegateEndpoints.size()).add("selector", this.toStringSelector()).add("initialized", this.whenReady().isDone()).add("initialSelectionTimeoutMillis", this.initialSelectionTimeoutMillis).add("selectionTimeoutMillis", this.selectionTimeoutMillis).add("contextGroupChain", this.contextGroupChain).toString();
    }
}

