/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.DefaultEndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.LoadBalancer;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;

final class StickyEndpointSelectionStrategy
implements DefaultEndpointSelector.LoadBalancerFactory<LoadBalancer<Endpoint, ClientRequestContext>>,
EndpointSelectionStrategy {
    private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

    StickyEndpointSelectionStrategy(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new DefaultEndpointSelector<LoadBalancer<Endpoint, ClientRequestContext>>(endpointGroup, this);
    }

    @Override
    public LoadBalancer<Endpoint, ClientRequestContext> newLoadBalancer(@Nullable LoadBalancer<Endpoint, ClientRequestContext> oldLoadBalancer, List<Endpoint> candidates) {
        return LoadBalancer.ofSticky(candidates, this.requestContextHasher);
    }
}

