/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerListener;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerMetrics;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitState;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.EventCount;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.internal.common.metric.MicrometerUtil;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;

final class MetricCollectingCircuitBreakerListener
implements CircuitBreakerListener {
    private final MeterRegistry registry;
    private final String name;

    MetricCollectingCircuitBreakerListener(MeterRegistry registry, String name) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public void onStateChanged(String circuitBreakerName, CircuitState state) {
        this.metricsOf(circuitBreakerName).onStateChanged(state);
    }

    @Override
    @Deprecated
    public void onEventCountUpdated(String circuitBreakerName, EventCount eventCount) {
    }

    @Override
    public void onEventCountUpdated(String circuitBreakerName, io.opentelemetry.testing.internal.armeria.common.util.EventCount eventCount) throws Exception {
        this.metricsOf(circuitBreakerName).onCountUpdated(eventCount);
    }

    @Override
    public void onRequestRejected(String circuitBreakerName) {
        this.metricsOf(circuitBreakerName).onRequestRejected();
    }

    private CircuitBreakerMetrics metricsOf(String circuitBreakerName) {
        MeterIdPrefix idPrefix = new MeterIdPrefix(this.name, "name", circuitBreakerName);
        return MicrometerUtil.register(this.registry, idPrefix, CircuitBreakerMetrics.class, CircuitBreakerMetrics::new);
    }
}

