/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.Preprocessor;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.RpcResponse;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface RpcPreprocessor
extends Preprocessor<RpcRequest, RpcResponse> {
    public static RpcPreprocessor of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, EventLoop eventLoop) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(eventLoop, "eventLoop");
        return (delegate, ctx, req) -> {
            ctx.setSessionProtocol(sessionProtocol);
            ctx.setEndpointGroup(endpointGroup);
            ctx.setEventLoop(eventLoop);
            return (RpcResponse)delegate.execute(ctx, req);
        };
    }

    public static RpcPreprocessor of(SessionProtocol sessionProtocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return (delegate, ctx, req) -> {
            ctx.setSessionProtocol(sessionProtocol);
            ctx.setEndpointGroup(endpointGroup);
            return (RpcResponse)delegate.execute(ctx, req);
        };
    }
}

