/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpRequestDuplicatorWrapper;
import io.opentelemetry.testing.internal.armeria.client.SimpleDecoratingHttpClient;
import io.opentelemetry.testing.internal.armeria.client.redirect.CyclicRedirectsException;
import io.opentelemetry.testing.internal.armeria.client.redirect.RedirectConfig;
import io.opentelemetry.testing.internal.armeria.client.redirect.TooManyRedirectsException;
import io.opentelemetry.testing.internal.armeria.client.redirect.UnexpectedDomainRedirectException;
import io.opentelemetry.testing.internal.armeria.client.redirect.UnexpectedProtocolRedirectException;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.RequestTargetForm;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.stream.AbortedStreamException;
import io.opentelemetry.testing.internal.armeria.internal.client.AggregatedHttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientBuilderParamsUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.RedirectingClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class RedirectingClient
extends SimpleDecoratingHttpClient {
    private static final Set<HttpStatus> redirectStatuses = ImmutableSet.of(HttpStatus.MOVED_PERMANENTLY, HttpStatus.FOUND, HttpStatus.SEE_OTHER, HttpStatus.TEMPORARY_REDIRECT);
    private static final Set<SessionProtocol> httpAndHttps = Sets.immutableEnumSet((Enum)SessionProtocol.HTTP, (Enum[])new SessionProtocol[]{SessionProtocol.HTTPS});
    private static final Splitter pathSplitter = Splitter.on('/');
    private final Set<SessionProtocol> allowedProtocols;
    private final BiPredicate<ClientRequestContext, String> domainFilter;
    private final int maxRedirects;

    static Function<? super HttpClient, RedirectingClient> newDecorator(ClientBuilderParams params, RedirectConfig redirectConfig) {
        boolean undefinedUri = Clients.isUndefinedUri(params.uri()) || ClientBuilderParamsUtil.isPreprocessorUri(params.uri());
        Set<SessionProtocol> allowedProtocols = RedirectingClient.allowedProtocols(undefinedUri, redirectConfig.allowedProtocols(), params.scheme().sessionProtocol());
        BiPredicate<ClientRequestContext, String> domainFilter = RedirectingClient.domainFilter(undefinedUri, redirectConfig.domainFilter());
        return delegate -> new RedirectingClient((HttpClient)delegate, allowedProtocols, domainFilter, redirectConfig.maxRedirects());
    }

    private static Set<SessionProtocol> allowedProtocols(boolean undefinedUri, @Nullable Set<SessionProtocol> allowedProtocols, SessionProtocol usedProtocol) {
        if (undefinedUri) {
            if (allowedProtocols != null) {
                return allowedProtocols;
            }
            return httpAndHttps;
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(2);
        if (allowedProtocols != null) {
            builder.addAll(allowedProtocols);
        } else {
            builder.add((Object)SessionProtocol.HTTPS);
        }
        if (usedProtocol.isHttp()) {
            builder.add((Object)SessionProtocol.HTTP);
        } else if (usedProtocol.isHttps()) {
            builder.add((Object)SessionProtocol.HTTPS);
        }
        return builder.build();
    }

    private static BiPredicate<ClientRequestContext, String> domainFilter(boolean undefinedUri, @Nullable BiPredicate<ClientRequestContext, String> domainFilter) {
        if (domainFilter != null) {
            return domainFilter;
        }
        if (undefinedUri) {
            return RedirectingClientUtil.allowAllDomains;
        }
        return RedirectingClientUtil.allowSameDomain;
    }

    RedirectingClient(HttpClient delegate, Set<SessionProtocol> allowedProtocols, BiPredicate<ClientRequestContext, String> domainFilter, int maxRedirects) {
        super(delegate);
        this.allowedProtocols = allowedProtocols;
        this.domainFilter = domainFilter;
        this.maxRedirects = maxRedirects;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse res = HttpResponse.of(responseFuture, (EventExecutor)ctx.eventLoop());
        RedirectContext redirectCtx = new RedirectContext(ctx, req, res, responseFuture);
        if (ctx.exchangeType().isRequestStreaming()) {
            HttpRequestDuplicator reqDuplicator = req.toDuplicator(ctx.eventLoop().withoutContext(), 0L);
            this.execute0(ctx, redirectCtx, reqDuplicator, true);
        } else {
            req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), ctx.eventLoop())).handle((agg, cause) -> {
                if (cause != null) {
                    RedirectingClient.handleException(ctx, null, responseFuture, cause, true);
                } else {
                    AggregatedHttpRequestDuplicator reqDuplicator = new AggregatedHttpRequestDuplicator((AggregatedHttpRequest)agg);
                    this.execute0(ctx, redirectCtx, reqDuplicator, true);
                }
                return null;
            });
        }
        return res;
    }

    private void execute0(ClientRequestContext ctx, RedirectContext redirectCtx, HttpRequestDuplicator reqDuplicator, boolean initialAttempt) {
        ClientRequestContext derivedCtx;
        CompletableFuture<Void> originalReqWhenComplete = redirectCtx.request().whenComplete();
        CompletableFuture<HttpResponse> responseFuture = redirectCtx.responseFuture();
        if (originalReqWhenComplete.isCompletedExceptionally()) {
            originalReqWhenComplete.exceptionally(cause -> {
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, cause, initialAttempt);
                return null;
            });
            return;
        }
        if (redirectCtx.responseWhenComplete().isDone()) {
            redirectCtx.responseWhenComplete().handle((result, cause) -> {
                Throwable abortCause = cause != null ? cause : AbortedStreamException.get();
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, abortCause, initialAttempt);
                return null;
            });
            return;
        }
        HttpRequest duplicateReq = reqDuplicator.duplicate();
        try {
            derivedCtx = ClientUtil.newDerivedContext(ctx, duplicateReq, ctx.rpcRequest(), initialAttempt);
        }
        catch (Throwable t) {
            RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, t, initialAttempt);
            return;
        }
        HttpRequest req = derivedCtx.request();
        assert (req != null);
        HttpResponse response = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> HttpResponse.ofFailure(cause), req, true);
        derivedCtx.log().whenAvailable(RequestLogProperty.RESPONSE_HEADERS).thenAccept(log -> {
            Throwable cause2;
            if (log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) && (cause2 = log.responseCause()) != null) {
                RedirectingClient.abortResponse(response, derivedCtx, cause2);
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, cause2, false);
                return;
            }
            ResponseHeaders responseHeaders = log.responseHeaders();
            if (!redirectStatuses.contains(responseHeaders.status())) {
                RedirectingClient.endRedirect(ctx, reqDuplicator, responseFuture, response);
                return;
            }
            String location = responseHeaders.get(HttpHeaderNames.LOCATION);
            if (Strings.isNullOrEmpty(location)) {
                RedirectingClient.endRedirect(ctx, reqDuplicator, responseFuture, response);
                return;
            }
            RequestHeaders requestHeaders = log.requestHeaders();
            RequestTarget nextReqTarget = RedirectingClient.resolveLocation(ctx, location);
            if (nextReqTarget == null) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, new IllegalArgumentException("Invalid redirect location: " + location));
                return;
            }
            String nextScheme = nextReqTarget.scheme();
            String nextAuthority = nextReqTarget.authority();
            String nextHost = nextReqTarget.host();
            assert (nextReqTarget.form() == RequestTargetForm.ABSOLUTE && nextScheme != null && nextAuthority != null && nextHost != null) : "resolveLocation() must return an absolute request target: " + nextReqTarget;
            try {
                SessionProtocol nextProtocol = SessionProtocol.of(nextScheme);
                if (ctx.sessionProtocol() != nextProtocol && !this.allowedProtocols.contains((Object)nextProtocol)) {
                    RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, UnexpectedProtocolRedirectException.of(nextProtocol, this.allowedProtocols));
                    return;
                }
                if (!nextHost.equals(ctx.host()) && !this.domainFilter.test(ctx, nextHost)) {
                    RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, UnexpectedDomainRedirectException.of(nextHost));
                    return;
                }
            }
            catch (Throwable t) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, t);
                return;
            }
            HttpRequestDuplicator newReqDuplicator = RedirectingClient.newReqDuplicator(reqDuplicator, responseHeaders, requestHeaders, nextReqTarget.toString(), nextAuthority);
            try {
                redirectCtx.validateRedirects(nextReqTarget, newReqDuplicator.headers().method(), this.maxRedirects);
            }
            catch (Throwable t) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, t);
                return;
            }
            response.subscribe(ctx.eventLoop()).handleAsync((unused, cause) -> {
                if (cause != null) {
                    RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, cause);
                    return null;
                }
                this.execute0(ctx, redirectCtx, newReqDuplicator, false);
                return null;
            }, (Executor)ctx.eventLoop());
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static RequestTarget resolveLocation(ClientRequestContext ctx, String location) {
        String resolvedUri;
        long length = location.length();
        assert (length > 0L);
        if (location.charAt(0) == '/') {
            resolvedUri = length > 1L && location.charAt(1) == '/' ? ctx.sessionProtocol().uriText() + ':' + location : ctx.sessionProtocol().uriText() + "://" + ctx.authority() + location;
            return RequestTarget.forClient(resolvedUri);
        } else {
            int authorityIdx = ArmeriaHttpUtil.findAuthority(location);
            if (authorityIdx < 0) {
                resolvedUri = RedirectingClient.resolveRelativeLocation(ctx, location);
                if (resolvedUri != null) return RequestTarget.forClient(resolvedUri);
                return null;
            }
            SessionProtocol proto = SessionProtocol.find(location.substring(0, authorityIdx - 3));
            if (proto == null) return null;
            switch (proto) {
                case HTTP: 
                case HTTPS: {
                    resolvedUri = location;
                    return RequestTarget.forClient(resolvedUri);
                }
                default: {
                    if (proto.isHttp()) {
                        resolvedUri = "http://" + location.substring(authorityIdx);
                        return RequestTarget.forClient(resolvedUri);
                    }
                    if (!proto.isHttps()) return null;
                    resolvedUri = "https://" + location.substring(authorityIdx);
                    return RequestTarget.forClient(resolvedUri);
                }
            }
        }
    }

    @Nullable
    private static String resolveRelativeLocation(ClientRequestContext ctx, String location) {
        String originalPath = ctx.path();
        int lastSlashIdx = originalPath.lastIndexOf(47);
        assert (lastSlashIdx >= 0) : "originalPath doesn't contain a slash: " + originalPath;
        String fullPath = originalPath.substring(0, lastSlashIdx + 1) + location;
        Iterator<String> it = pathSplitter.split(fullPath).iterator();
        assert (it.hasNext() && it.next().isEmpty()) : fullPath;
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tmp.stringBuilder();
            buf.append(ctx.sessionProtocol().uriText()).append("://").append(ctx.authority());
            int authorityEndIdx = buf.length();
            block14: while (it.hasNext()) {
                String component;
                switch (component = it.next()) {
                    case ".": {
                        if (it.hasNext()) continue block14;
                        buf.append('/');
                        continue block14;
                    }
                    case "..": {
                        int idx = buf.lastIndexOf("/");
                        if (idx < authorityEndIdx) {
                            String string = null;
                            return string;
                        }
                        if (it.hasNext()) {
                            buf.delete(idx, buf.length());
                            continue block14;
                        }
                        buf.delete(idx + 1, buf.length());
                        continue block14;
                    }
                }
                buf.append('/').append(component);
            }
            String string = buf.toString();
            return string;
        }
    }

    private static HttpRequestDuplicator newReqDuplicator(HttpRequestDuplicator reqDuplicator, ResponseHeaders responseHeaders, RequestHeaders requestHeaders, String nextUri, String nextAuthority) {
        RequestHeadersBuilder builder = requestHeaders.toBuilder();
        builder.path(nextUri);
        builder.authority(nextAuthority);
        HttpMethod method = requestHeaders.method();
        if (responseHeaders.status() == HttpStatus.SEE_OTHER && method != HttpMethod.GET && method != HttpMethod.HEAD) {
            builder.method(HttpMethod.GET);
            reqDuplicator.abort();
            return new AggregatedHttpRequestDuplicator(AggregatedHttpRequest.of(builder.build()));
        }
        return new HttpRequestDuplicatorWrapper(reqDuplicator, builder.build());
    }

    private static void endRedirect(ClientRequestContext ctx, HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> responseFuture, HttpResponse response) {
        ctx.logBuilder().endResponseWithLastChild();
        responseFuture.complete(response);
        reqDuplicator.close();
    }

    private static void handleException(ClientRequestContext ctx, ClientRequestContext derivedCtx, HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> future, HttpResponse originalRes, Throwable cause) {
        RedirectingClient.abortResponse(originalRes, derivedCtx, cause);
        RedirectingClient.handleException(ctx, reqDuplicator, future, cause, false);
    }

    private static void handleException(ClientRequestContext ctx, @Nullable HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> future, Throwable cause, boolean initialAttempt) {
        future.completeExceptionally(cause);
        if (reqDuplicator != null) {
            reqDuplicator.abort(cause);
        }
        if (initialAttempt) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }

    private static void abortResponse(HttpResponse originalRes, ClientRequestContext derivedCtx, @Nullable Throwable cause) {
        RequestLogBuilder logBuilder = derivedCtx.logBuilder();
        logBuilder.responseContent(null, null);
        logBuilder.responseContentPreview(null);
        if (cause != null) {
            originalRes.abort(cause);
        } else {
            originalRes.abort();
        }
    }

    private static String buildUri(ClientRequestContext ctx, RequestHeaders headers) {
        String originalUri;
        try (TemporaryThreadLocals threadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = threadLocals.stringBuilder();
            if (ctx.sessionProtocol().isHttp()) {
                sb.append(SessionProtocol.HTTP.uriText());
            } else {
                sb.append(SessionProtocol.HTTPS.uriText());
            }
            sb.append("://");
            String authority = headers.authority();
            Endpoint endpoint = ctx.endpoint();
            assert (endpoint != null);
            if (authority == null) {
                authority = endpoint.authority();
            }
            RedirectingClient.appendAuthority(ctx, endpoint, sb, authority);
            sb.append(headers.path());
            originalUri = sb.toString();
        }
        return originalUri;
    }

    private static void appendAuthority(ClientRequestContext ctx, Endpoint endpoint, StringBuilder sb, String authority) {
        if (authority.charAt(0) == '[') {
            int closingBracketPos = authority.lastIndexOf(93);
            if (closingBracketPos < 0) {
                throw new IllegalStateException("Invalid authority: " + authority);
            }
            sb.append(authority);
            if (authority.indexOf(58, closingBracketPos) < 0) {
                RedirectingClient.addPort(ctx, endpoint, sb);
            }
            return;
        }
        if (NetUtil.isValidIpV6Address(authority)) {
            sb.append('[');
            sb.append(authority);
            sb.append(']');
            RedirectingClient.addPort(ctx, endpoint, sb);
            return;
        }
        sb.append(authority);
        if (authority.lastIndexOf(58) < 0) {
            RedirectingClient.addPort(ctx, endpoint, sb);
        }
    }

    private static void addPort(ClientRequestContext ctx, Endpoint endpoint, StringBuilder sb) {
        sb.append(':');
        sb.append(endpoint.port(ctx.sessionProtocol().defaultPort()));
    }

    static class RedirectContext {
        private final ClientRequestContext ctx;
        private final HttpRequest request;
        private final CompletableFuture<Void> responseWhenComplete;
        private final CompletableFuture<HttpResponse> responseFuture;
        @Nullable
        private String originalUri;
        @Nullable
        private Set<RedirectSignature> redirectSignatures;

        RedirectContext(ClientRequestContext ctx, HttpRequest request, HttpResponse response, CompletableFuture<HttpResponse> responseFuture) {
            this.ctx = ctx;
            this.request = request;
            this.responseWhenComplete = response.whenComplete();
            this.responseFuture = responseFuture;
        }

        HttpRequest request() {
            return this.request;
        }

        CompletableFuture<Void> responseWhenComplete() {
            return this.responseWhenComplete;
        }

        CompletableFuture<HttpResponse> responseFuture() {
            return this.responseFuture;
        }

        void validateRedirects(RequestTarget nextReqTarget, HttpMethod nextMethod, int maxRedirects) {
            if (this.redirectSignatures == null) {
                this.redirectSignatures = new LinkedHashSet<RedirectSignature>();
                String originalProtocol = this.ctx.sessionProtocol().isTls() ? "https" : "http";
                String originalAuthority = this.ctx.authority();
                assert (originalAuthority != null);
                RedirectSignature originalSignature = new RedirectSignature(originalProtocol, originalAuthority, this.request.headers().path(), this.request.method());
                this.redirectSignatures.add(originalSignature);
            }
            String nextScheme = nextReqTarget.scheme();
            String nextAuthority = nextReqTarget.authority();
            assert (nextScheme != null);
            assert (nextAuthority != null);
            RedirectSignature signature = new RedirectSignature(nextScheme, nextAuthority, nextReqTarget.pathAndQuery(), nextMethod);
            if (!this.redirectSignatures.add(signature)) {
                throw CyclicRedirectsException.of(this.originalUri(), this.redirectUris());
            }
            if (this.redirectSignatures.size() - 1 > maxRedirects) {
                throw TooManyRedirectsException.of(maxRedirects, this.originalUri(), this.redirectUris());
            }
        }

        String originalUri() {
            if (this.originalUri == null) {
                this.originalUri = RedirectingClient.buildUri(this.ctx, this.request.headers());
            }
            return this.originalUri;
        }

        Set<String> redirectUris() {
            assert (this.redirectSignatures != null);
            return this.redirectSignatures.stream().map(RedirectSignature::uri).collect(ImmutableSet.toImmutableSet());
        }
    }

    static class RedirectSignature {
        private final String protocol;
        private final String authority;
        private final String pathAndQuery;
        private final HttpMethod method;

        RedirectSignature(String protocol, String authority, String pathAndQuery, HttpMethod method) {
            this.protocol = protocol;
            this.authority = authority;
            this.pathAndQuery = pathAndQuery;
            this.method = method;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.protocol, this.authority, this.pathAndQuery, this.method});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RedirectSignature)) {
                return false;
            }
            RedirectSignature that = (RedirectSignature)obj;
            return this.pathAndQuery.equals(that.pathAndQuery) && this.authority.equals(that.authority) && this.protocol.equals(that.protocol) && this.method == that.method;
        }

        String uri() {
            return this.protocol + "://" + this.authority + this.pathAndQuery;
        }
    }
}

