/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.proxy.HAProxyConfig;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.handler.codec.haproxy.HAProxyCommand;
import io.opentelemetry.testing.internal.io.netty.handler.codec.haproxy.HAProxyMessage;
import io.opentelemetry.testing.internal.io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectException;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectionEvent;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

final class HAProxyHandler
extends ChannelOutboundHandlerAdapter {
    private final HAProxyConfig haProxyConfig;
    private static final String PROTOCOL = "haproxy";
    private static final String AUTH = "none";

    HAProxyHandler(HAProxyConfig haProxyConfig) {
        this.haProxyConfig = haProxyConfig;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), null, HAProxyMessageEncoder.INSTANCE);
        super.handlerAdded(ctx);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        InetSocketAddress proxyAddress = this.haProxyConfig.proxyAddress();
        assert (proxyAddress != null);
        ChannelPromise connectionPromise = ctx.newPromise();
        ctx.connect(proxyAddress, localAddress, connectionPromise);
        connectionPromise.addListener(f -> {
            if (!f.isSuccess()) {
                promise.tryFailure(HAProxyHandler.wrapException(f.cause()));
                ctx.close();
                return;
            }
            try {
                ctx.writeAndFlush(HAProxyHandler.createMessage(this.haProxyConfig, ctx.channel(), remoteAddress)).addListener(f0 -> {
                    if (f0.isSuccess()) {
                        ctx.pipeline().remove(HAProxyMessageEncoder.INSTANCE);
                        ProxyConnectionEvent event = new ProxyConnectionEvent(PROTOCOL, AUTH, proxyAddress, remoteAddress);
                        promise.trySuccess();
                        ctx.pipeline().fireUserEventTriggered(event);
                    } else {
                        promise.tryFailure(HAProxyHandler.wrapException(f0.cause()));
                        ctx.close();
                    }
                });
            }
            catch (Exception e) {
                promise.tryFailure(HAProxyHandler.wrapException(e));
                ctx.close();
            }
            finally {
                ctx.pipeline().remove(this);
            }
        });
    }

    private static ProxyConnectException wrapException(Throwable e) {
        if (e instanceof ProxyConnectException) {
            return (ProxyConnectException)e;
        }
        return new ProxyConnectException(e);
    }

    private static HAProxyMessage createMessage(HAProxyConfig haProxyConfig, Channel channel, SocketAddress remoteAddress) throws ProxyConnectException {
        InetSocketAddress srcSocketAddress = haProxyConfig.sourceAddress() != null ? haProxyConfig.sourceAddress() : (InetSocketAddress)channel.localAddress();
        InetSocketAddress destSocketAddress = (InetSocketAddress)remoteAddress;
        InetAddress srcAddress = srcSocketAddress.getAddress();
        InetAddress destAddress = destSocketAddress.getAddress();
        if (srcAddress instanceof Inet4Address && destAddress instanceof Inet4Address) {
            return new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, srcAddress.getHostAddress(), destAddress.getHostAddress(), srcSocketAddress.getPort(), destSocketAddress.getPort());
        }
        return new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, HAProxyHandler.translateToInet6(srcAddress).getHostAddress(), HAProxyHandler.translateToInet6(destAddress).getHostAddress(), srcSocketAddress.getPort(), destSocketAddress.getPort());
    }

    private static Inet6Address translateToInet6(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return (Inet6Address)inetAddress;
        }
        return NetUtil.getByName(inetAddress.getHostAddress());
    }
}

