/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.BlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.DefaultBlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpPreClient;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.RestClient;
import io.opentelemetry.testing.internal.armeria.client.UserClient;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.WebClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.RequestTargetForm;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.DefaultClientRequestContext;
import io.opentelemetry.testing.internal.armeria.internal.client.TailPreClient;
import io.opentelemetry.testing.internal.armeria.internal.client.endpoint.UndefinedEndpointGroup;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;

final class DefaultWebClient
extends UserClient<HttpRequest, HttpResponse>
implements WebClient {
    static final WebClient DEFAULT = new WebClientBuilder().build();
    static final RequestOptions RESPONSE_STREAMING_REQUEST_OPTIONS = RequestOptions.builder().exchangeType(ExchangeType.RESPONSE_STREAMING).build();
    @Nullable
    private BlockingWebClient blockingWebClient;
    @Nullable
    private RestClient restClient;
    private final HttpPreClient preClient;

    DefaultWebClient(ClientBuilderParams params, HttpClient delegate, MeterRegistry meterRegistry) {
        super(params, delegate, meterRegistry, HttpResponse::of, (ctx, cause) -> HttpResponse.ofFailure(cause));
        HttpPreClient tailPreClient = TailPreClient.of(this.unwrap(), this.futureConverter(), this.errorResponseFactory());
        this.preClient = this.options().clientPreprocessors().decorate(tailPreClient);
    }

    @Override
    public HttpResponse execute(HttpRequest req, RequestOptions requestOptions) {
        SessionProtocol protocol;
        EndpointGroup endpointGroup;
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(requestOptions, "requestOptions");
        String originalPath = req.path();
        String prefix = Strings.emptyToNull(this.uri().getRawPath());
        RequestTarget reqTarget = RequestTarget.forClient(originalPath, prefix);
        if (reqTarget == null) {
            return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Invalid request target: " + originalPath));
        }
        if (Clients.isUndefinedUri(this.uri())) {
            String authority;
            String scheme;
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                scheme = reqTarget.scheme();
                authority = reqTarget.authority();
                assert (scheme != null);
                assert (authority != null);
            } else {
                scheme = req.scheme();
                authority = req.authority();
            }
            endpointGroup = authority != null ? Endpoint.parse(authority) : UndefinedEndpointGroup.of();
            if (scheme != null) {
                try {
                    protocol = Scheme.parse(scheme).sessionProtocol();
                }
                catch (Exception e) {
                    return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Failed to parse a scheme: " + scheme, e));
                }
            } else {
                protocol = SessionProtocol.HTTP;
            }
        } else {
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Cannot send a request with a \":path\" header that contains an authority, because the client was created with a base URI. path: " + originalPath));
            }
            endpointGroup = this.endpointGroup();
            protocol = this.scheme().sessionProtocol();
        }
        String newPath = reqTarget.pathAndQuery();
        HttpRequest newReq = newPath.equals(originalPath) ? req : req.withHeaders(req.headers().toBuilder().path(newPath));
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(protocol, newReq, newReq.method(), null, reqTarget, endpointGroup, requestOptions, this.options(), this.meterRegistry());
        return (HttpResponse)ClientUtil.executeWithFallback(this.preClient, ctx, newReq, this.errorResponseFactory());
    }

    private static HttpResponse abortRequestAndReturnFailureResponse(HttpRequest req, IllegalArgumentException cause) {
        req.abort(cause);
        return HttpResponse.ofFailure(cause);
    }

    @Override
    public BlockingWebClient blocking() {
        if (this.blockingWebClient != null) {
            return this.blockingWebClient;
        }
        this.blockingWebClient = new DefaultBlockingWebClient(this);
        return this.blockingWebClient;
    }

    @Override
    public RestClient asRestClient() {
        if (this.restClient != null) {
            return this.restClient;
        }
        this.restClient = RestClient.of(this);
        return this.restClient;
    }

    @Override
    public HttpClient unwrap() {
        return (HttpClient)super.unwrap();
    }
}

