/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientTlsConfig;
import io.opentelemetry.testing.internal.armeria.common.AbstractTlsConfigBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class ClientTlsConfigBuilder
extends AbstractTlsConfigBuilder<ClientTlsConfigBuilder> {
    private boolean tlsNoVerifySet;
    private final Set<String> insecureHosts = new HashSet<String>();

    ClientTlsConfigBuilder() {
    }

    public ClientTlsConfigBuilder tlsNoVerify() {
        this.tlsNoVerifySet = true;
        Preconditions.checkState(this.insecureHosts.isEmpty(), "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        return this;
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(String ... insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        return this.tlsNoVerifyHosts(ImmutableList.copyOf(insecureHosts));
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(Iterable<String> insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        Preconditions.checkState(!this.tlsNoVerifySet, "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        insecureHosts.forEach(this.insecureHosts::add);
        return this;
    }

    public ClientTlsConfig build() {
        return new ClientTlsConfig(this.allowsUnsafeCiphers(), this.meterIdPrefix(), this.tlsCustomizer(), this.tlsNoVerifySet, ImmutableSet.copyOf(this.insecureHosts));
    }
}

