/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http2.impl;

import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.HttpProcessors;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpProcessor;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpProcessorBuilder;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.RequestExpectContinue;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.RequestUserAgent;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.ResponseDate;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.ResponseServer;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2RequestConnControl;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2RequestContent;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2RequestTargetHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2RequestValidateHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2ResponseConnControl;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.protocol.H2ResponseContent;
import io.opentelemetry.testing.internal.apachehttp.core5.util.TextUtils;
import io.opentelemetry.testing.internal.apachehttp.core5.util.VersionInfo;

public final class H2Processors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(new ResponseDate(), new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "io.opentelemetry.testing.internal.apachehttp.core5", H2Processors.class)), new H2ResponseContent(), new H2ResponseConnControl()).addAll(new H2RequestValidateHost());
    }

    public static HttpProcessor server(String serverInfo) {
        return H2Processors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return H2Processors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(new H2RequestContent(), new H2RequestTargetHost(), new H2RequestConnControl(), new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "io.opentelemetry.testing.internal.apachehttp.core5", HttpProcessors.class)), new RequestExpectContinue());
    }

    public static HttpProcessor client(String agentInfo) {
        return H2Processors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return H2Processors.customClient(null).build();
    }
}

