/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.protocol;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.EntityDetails;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequestInterceptor;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpContext;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpDateGenerator;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (entity != null && !request.containsHeader("Date")) {
            request.setHeader("Date", HttpDateGenerator.INSTANCE.getCurrentDate());
        }
    }
}

