/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.nio.ssl;

import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http.URIScheme;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.ssl.TlsStrategy;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.ssl.TlsSupport;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ssl.SSLBufferMode;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ssl.SSLSessionInitializer;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ssl.SSLSessionVerifier;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ssl.TransportSecurityLayer;
import io.opentelemetry.testing.internal.apachehttp.core5.ssl.SSLContexts;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class BasicClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public BasicClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public BasicClientTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    @Override
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            tlsSession.startTls(this.sslContext, host, this.sslBufferMode, TlsSupport.enforceStrongSecurity(this.initializer), this.verifier, handshakeTimeout);
            return true;
        }
        return false;
    }
}

