/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.protocol;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.EntityDetails;
import io.opentelemetry.testing.internal.apachehttp.core5.http.Header;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequestInterceptor;
import io.opentelemetry.testing.internal.apachehttp.core5.http.Method;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpContext;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (this.defaultHeaders != null) {
            for (Header header : this.defaultHeaders) {
                if (request.containsHeader(header.getName())) continue;
                request.addHeader(header);
            }
        }
    }
}

