/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.nio;

import io.opentelemetry.testing.internal.apachehttp.client5.http.DnsResolver;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.nio.MultihomeIOSessionRequester;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.concurrent.FutureCallback;
import io.opentelemetry.testing.internal.apachehttp.core5.net.NamedEndpoint;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ConnectionInitiator;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOSession;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Timeout;
import java.net.SocketAddress;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class MultihomeConnectionInitiator
implements ConnectionInitiator {
    private final ConnectionInitiator connectionInitiator;
    private final MultihomeIOSessionRequester sessionRequester;

    public MultihomeConnectionInitiator(ConnectionInitiator connectionInitiator, DnsResolver dnsResolver) {
        this.connectionInitiator = Args.notNull(connectionInitiator, "Connection initiator");
        this.sessionRequester = new MultihomeIOSessionRequester(dnsResolver);
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout connectTimeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        return this.sessionRequester.connect(this.connectionInitiator, remoteEndpoint, remoteAddress, localAddress, connectTimeout, attachment, callback);
    }

    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress localAddress, Timeout connectTimeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        return this.sessionRequester.connect(this.connectionInitiator, remoteEndpoint, localAddress, connectTimeout, attachment, callback);
    }
}

