/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async;

import io.opentelemetry.testing.internal.apachehttp.core5.function.Supplier;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.AsyncPushConsumer;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.UriPatternMatcher;
import io.opentelemetry.testing.internal.apachehttp.core5.net.URIAuthority;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AsyncPushConsumerRegistry {
    private final UriPatternMatcher<Supplier<AsyncPushConsumer>> primary = new UriPatternMatcher();
    private final ConcurrentMap<String, UriPatternMatcher<Supplier<AsyncPushConsumer>>> hostMap = new ConcurrentHashMap<String, UriPatternMatcher<Supplier<AsyncPushConsumer>>>();

    private UriPatternMatcher<Supplier<AsyncPushConsumer>> getPatternMatcher(String hostname) {
        if (hostname == null) {
            return this.primary;
        }
        UriPatternMatcher hostMatcher = (UriPatternMatcher)this.hostMap.get(hostname);
        if (hostMatcher != null) {
            return hostMatcher;
        }
        return this.primary;
    }

    public AsyncPushConsumer get(HttpRequest request) {
        Supplier<AsyncPushConsumer> supplier;
        Args.notNull(request, "Request");
        URIAuthority authority = request.getAuthority();
        String key = authority != null ? authority.getHostName().toLowerCase(Locale.ROOT) : null;
        UriPatternMatcher<Supplier<AsyncPushConsumer>> patternMatcher = this.getPatternMatcher(key);
        if (patternMatcher == null) {
            return null;
        }
        String path = request.getPath();
        int i = path.indexOf(63);
        if (i != -1) {
            path = path.substring(0, i);
        }
        return (supplier = patternMatcher.lookup(path)) != null ? supplier.get() : null;
    }

    public void register(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        if (hostname == null) {
            this.primary.register(uriPattern, supplier);
        } else {
            UriPatternMatcher newMatcher;
            String key = hostname.toLowerCase(Locale.ROOT);
            UriPatternMatcher<Supplier<AsyncPushConsumer>> matcher = (UriPatternMatcher<Supplier<AsyncPushConsumer>>)this.hostMap.get(key);
            if (matcher == null && (matcher = this.hostMap.putIfAbsent(key, newMatcher = new UriPatternMatcher())) == null) {
                matcher = newMatcher;
            }
            matcher.register(uriPattern, supplier);
        }
    }
}

