/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachecommons.io.function;

import io.opentelemetry.testing.internal.apachecommons.io.function.IOIterator;
import io.opentelemetry.testing.internal.apachecommons.io.function.Uncheck;
import java.util.Iterator;
import java.util.Objects;

final class UncheckedIOIterator<E>
implements Iterator<E> {
    private final IOIterator<E> delegate;

    UncheckedIOIterator(IOIterator<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public boolean hasNext() {
        return Uncheck.getAsBoolean(this.delegate::hasNext);
    }

    @Override
    public E next() {
        return (E)Uncheck.get(this.delegate::next);
    }

    @Override
    public void remove() {
        Uncheck.run(this.delegate::remove);
    }
}

