/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachecommons.fileupload.disk;

import io.opentelemetry.testing.internal.apachecommons.fileupload.FileItem;
import io.opentelemetry.testing.internal.apachecommons.fileupload.FileItemHeaders;
import io.opentelemetry.testing.internal.apachecommons.fileupload.FileUploadException;
import io.opentelemetry.testing.internal.apachecommons.fileupload.ParameterParser;
import io.opentelemetry.testing.internal.apachecommons.fileupload.util.Streams;
import io.opentelemetry.testing.internal.apachecommons.io.FileUtils;
import io.opentelemetry.testing.internal.apachecommons.io.function.Uncheck;
import io.opentelemetry.testing.internal.apachecommons.io.output.DeferredFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class DiskFileItem
implements FileItem {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private byte[] cachedContent;
    private final String contentType;
    private String defaultCharset = "ISO-8859-1";
    private transient DeferredFileOutputStream dfos;
    private String fieldName;
    private final String fileName;
    private FileItemHeaders headers;
    private boolean formField;
    private final File repository;
    private long size = -1L;
    private final int sizeThreshold;
    private transient File tempFile;

    private static String getUniqueId() {
        int limit = 100000000;
        int current = COUNTER.getAndIncrement();
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    public DiskFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.formField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    private void clear() {
        this.cachedContent = null;
    }

    @Override
    public void delete() {
        this.clear();
        File outputFile = this.getStoreLocation();
        if (outputFile != null && !this.isInMemory() && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected void finalize() throws Throwable {
        if (this.dfos == null || this.dfos.isInMemory()) {
            return;
        }
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
        super.finalize();
    }

    @Override
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null && this.dfos != null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent != null ? (byte[])this.cachedContent.clone() : new byte[]{};
        }
        return Uncheck.get(() -> Files.readAllBytes(this.dfos.getFile().toPath()));
    }

    public String getCharSet() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return params.get("charset");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return Files.newInputStream(this.dfos.getPath(), new OpenOption[0]);
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getName() {
        return Streams.checkFileName(this.fileName);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File outputFile = this.getTempFile();
            this.dfos = DeferredFileOutputStream.builder().setThreshold(this.sizeThreshold).setOutputFile(outputFile).get();
        }
        return this.dfos;
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    public File getStoreLocation() {
        if (this.dfos == null) {
            return null;
        }
        if (this.isInMemory()) {
            return null;
        }
        return this.dfos.getFile();
    }

    @Override
    public String getString() {
        byte[] rawData = this.get();
        String charset = this.getCharSet();
        if (charset == null) {
            charset = this.defaultCharset;
        }
        try {
            return new String(rawData, charset);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File tempDir = this.repository;
            if (tempDir == null) {
                tempDir = new File(System.getProperty("java.io.tmpdir"));
            }
            String tempFileName = String.format("upload_%s_%s.tmp", UID, DiskFileItem.getUniqueId());
            this.tempFile = new File(tempDir, tempFileName);
        }
        return this.tempFile;
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public void setDefaultCharset(String charset) {
        this.defaultCharset = charset;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void setFormField(boolean formField) {
        this.formField = formField;
    }

    @Override
    public void setHeaders(FileItemHeaders headers) {
        this.headers = headers;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getStoreLocation(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            try (FileOutputStream fout2 = new FileOutputStream(file);){
                fout2.write(this.get());
            }
            catch (IOException fout2) {}
        } else {
            File outputFile = this.getStoreLocation();
            if (outputFile == null) {
                throw new FileUploadException("Cannot write uploaded file to disk!");
            }
            this.size = outputFile.length();
            if (file.exists() && !file.delete()) {
                throw new FileUploadException("Cannot write uploaded file to disk!");
            }
            FileUtils.moveFile(outputFile, file);
        }
    }
}

