/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.testing.common;

import io.opentelemetry.javaagent.bootstrap.ExceptionLogger;
import io.opentelemetry.javaagent.testing.common.AgentClassLoaderAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TestAgentListenerAccess {
    private static final MethodHandle reset;
    private static final MethodHandle getInstrumentationErrorCount;
    private static final MethodHandle getMuzzleFailureCount;
    private static final MethodHandle getIgnoredButTransformedClassNames;
    private static final MethodHandle addSkipTransformationCondition;
    private static final MethodHandle addSkipErrorCondition;

    public static void reset() {
        try {
            reset.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.reset", t);
        }
    }

    public static int getInstrumentationErrorCount() {
        try {
            return getInstrumentationErrorCount.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.getInstrumentationErrorCount", t);
        }
    }

    public static int getAndResetMuzzleFailureCount() {
        try {
            return getMuzzleFailureCount.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.getMuzzleFailureCount", t);
        }
    }

    public static List<String> getIgnoredButTransformedClassNames() {
        try {
            return getIgnoredButTransformedClassNames.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.getIgnoredButTransformedClassNames", t);
        }
    }

    public static void addSkipTransformationCondition(Function<String, Boolean> condition) {
        try {
            addSkipTransformationCondition.invokeExact(condition);
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.addSkipTransformationCondition", t);
        }
    }

    public static void addSkipErrorCondition(BiFunction<String, Throwable, Boolean> condition) {
        try {
            addSkipErrorCondition.invokeExact(condition);
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke TestAgentListener.addSkipErrorCondition", t);
        }
    }

    public static int getAndResetAdviceFailureCount() {
        return ExceptionLogger.getAndReset();
    }

    private TestAgentListenerAccess() {
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> testAgentListenerClass = AgentClassLoaderAccess.loadClass("io.opentelemetry.javaagent.testing.bytebuddy.TestAgentListener");
            reset = lookup.findStatic(testAgentListenerClass, "reset", MethodType.methodType(Void.TYPE));
            getInstrumentationErrorCount = lookup.findStatic(testAgentListenerClass, "getInstrumentationErrorCount", MethodType.methodType(Integer.TYPE));
            getMuzzleFailureCount = lookup.findStatic(testAgentListenerClass, "getAndResetMuzzleFailureCount", MethodType.methodType(Integer.TYPE));
            getIgnoredButTransformedClassNames = lookup.findStatic(testAgentListenerClass, "getIgnoredButTransformedClassNames", MethodType.methodType(List.class));
            addSkipTransformationCondition = lookup.findStatic(testAgentListenerClass, "addSkipTransformationCondition", MethodType.methodType(Void.TYPE, Function.class));
            addSkipErrorCondition = lookup.findStatic(testAgentListenerClass, "addSkipErrorCondition", MethodType.methodType(Void.TYPE, BiFunction.class));
        }
        catch (Throwable t) {
            throw new AssertionError("Could not initialize accessors for TestAgentListener.", t);
        }
    }
}

