/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.testing.common;

import java.lang.reflect.Method;

public final class AgentClassLoaderAccess {
    private static final ClassLoader agentClassLoader;

    public static Class<?> loadClass(String name) {
        try {
            return agentClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("Could not load class from agent class loader", e);
        }
    }

    private AgentClassLoaderAccess() {
    }

    static {
        try {
            Class<?> agentInitializerClass = ClassLoader.getSystemClassLoader().loadClass("io.opentelemetry.javaagent.bootstrap.AgentInitializer");
            Method getExtensionsClassLoader = agentInitializerClass.getDeclaredMethod("getExtensionsClassLoader", new Class[0]);
            agentClassLoader = (ClassLoader)getExtensionsClassLoader.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new AssertionError("Could not access agent class loader", t);
        }
    }
}

