/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.util;

import io.opentelemetry.context.ContextStorage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.awaitility.Awaitility;

public final class ContextStorageCloser {
    private ContextStorageCloser() {
    }

    public static void close(ContextStorage storage) throws Exception {
        if (storage instanceof AutoCloseable) {
            ContextStorageCloser.cleanup((AutoCloseable)storage);
        }
    }

    private static void cleanup(AutoCloseable storage) throws Exception {
        ContextRestorer restorer = ContextRestorer.create((ContextStorage)storage);
        if (restorer == null) {
            storage.close();
            return;
        }
        Awaitility.await().ignoreException(AssertionError.class).atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofSeconds(1L)).pollDelay(Duration.ZERO).until(() -> restorer.runWithRestore(storage));
    }

    private static abstract class ContextRestorer {
        private ContextRestorer() {
        }

        abstract void restore();

        boolean runWithRestore(AutoCloseable target) {
            try {
                target.close();
                return true;
            }
            catch (Throwable throwable) {
                this.restore();
                if (throwable instanceof AssertionError) {
                    System.err.println();
                    for (Map.Entry<Thread, StackTraceElement[]> threadEntry : Thread.getAllStackTraces().entrySet()) {
                        System.err.println("Thread " + threadEntry.getKey());
                        for (StackTraceElement stackTraceElement : threadEntry.getValue()) {
                            System.err.println("\t" + stackTraceElement);
                        }
                        System.err.println();
                    }
                    throw (AssertionError)((Object)throwable);
                }
                throw new IllegalStateException(throwable);
            }
        }

        static ContextRestorer create(ContextStorage storage) throws NoSuchFieldException, IllegalAccessException {
            Object strictContextStorage = ContextRestorer.getStrictContextStorage(storage);
            if (strictContextStorage == null) {
                return null;
            }
            Object pendingScopes = ContextRestorer.getStrictContextStoragePendingScopes(strictContextStorage);
            Field mapField = pendingScopes.getClass().getDeclaredField("map");
            mapField.setAccessible(true);
            final ConcurrentHashMap map = (ConcurrentHashMap)mapField.get(pendingScopes);
            final HashMap copy = new HashMap(map);
            return new ContextRestorer(){

                @Override
                void restore() {
                    map.putAll(copy);
                }
            };
        }

        private static Object getStrictContextStoragePendingScopes(Object strictContextStorage) throws NoSuchFieldException, IllegalAccessException {
            Field field = strictContextStorage.getClass().getDeclaredField("pendingScopes");
            field.setAccessible(true);
            return field.get(strictContextStorage);
        }

        private static Object getStrictContextStorage(ContextStorage storage) throws NoSuchFieldException, IllegalAccessException {
            if (storage.getClass().getName().contains("StrictContextStorage")) {
                return storage;
            }
            Object contextStorage = ContextRestorer.getAgentContextStorage();
            if (contextStorage == null) {
                return null;
            }
            Class<?> contextStorageClass = (contextStorage = ContextRestorer.unwrapStrictContextStressor(contextStorage)).getClass();
            if (contextStorageClass.getName().contains("StrictContextStorage")) {
                return contextStorage;
            }
            return null;
        }

        private static Object getAgentContextStorage() {
            try {
                Class<?> contextStorageClass = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorage");
                Method method = contextStorageClass.getDeclaredMethod("get", new Class[0]);
                return method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static Object unwrapStrictContextStressor(Object contextStorage) throws NoSuchFieldException, IllegalAccessException {
            Class<?> contextStorageClass = contextStorage.getClass();
            if (contextStorageClass.getName().contains("StrictContextStressor")) {
                Field field = contextStorageClass.getDeclaredField("contextStorage");
                field.setAccessible(true);
                return field.get(contextStorage);
            }
            return contextStorage;
        }
    }
}

