/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.provider;

import io.opentelemetry.instrumentation.testing.provider.TestSpanExporterComponentProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizer;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ConsoleExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LoggerProviderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MeterProviderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.PeriodicMetricReaderModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.PushMetricExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleLogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleSpanProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TracerProviderModel;
import java.util.ArrayList;
import java.util.Collections;

public class TestExporterCustomizerProvider
implements DeclarativeConfigurationCustomizerProvider {
    public void customize(DeclarativeConfigurationCustomizer customizer) {
        if (TestSpanExporterComponentProvider.getSpanExporter() == null) {
            return;
        }
        customizer.addModelCustomizer(model -> {
            if (model.getTracerProvider() == null) {
                TestExporterCustomizerProvider.addTracerProvider(model);
            }
            if (model.getLoggerProvider() == null) {
                TestExporterCustomizerProvider.addLoggerProvider(model);
            }
            if (model.getMeterProvider() == null) {
                TestExporterCustomizerProvider.addMeterProvider(model);
            }
            return model;
        });
    }

    private static void addTracerProvider(OpenTelemetryConfigurationModel model) {
        ArrayList<SpanProcessorModel> processors = new ArrayList<SpanProcessorModel>();
        processors.add(TestExporterCustomizerProvider.getProcessorModel(new SpanExporterModel().withAdditionalProperty("test", null)));
        processors.add(TestExporterCustomizerProvider.getProcessorModel(new SpanExporterModel().withConsole(new ConsoleExporterModel())));
        model.withTracerProvider(new TracerProviderModel().withProcessors(processors));
    }

    private static SpanProcessorModel getProcessorModel(SpanExporterModel exporter) {
        return new SpanProcessorModel().withSimple(new SimpleSpanProcessorModel().withExporter(exporter));
    }

    private static void addLoggerProvider(OpenTelemetryConfigurationModel model) {
        model.withLoggerProvider(new LoggerProviderModel().withProcessors(Collections.singletonList(new LogRecordProcessorModel().withSimple(new SimpleLogRecordProcessorModel().withExporter(new LogRecordExporterModel().withAdditionalProperty("test", null))))));
    }

    private static void addMeterProvider(OpenTelemetryConfigurationModel model) {
        model.withMeterProvider(new MeterProviderModel().withReaders(Collections.singletonList(new MetricReaderModel().withPeriodic(new PeriodicMetricReaderModel().withInterval(Integer.valueOf(1000000)).withExporter(new PushMetricExporterModel().withAdditionalProperty("test", null))))));
    }
}

