/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.testing.junit.http.ServerEndpoint;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class HttpServerTestOptions {
    public static final Set<AttributeKey<?>> DEFAULT_HTTP_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<AttributeKey>(Arrays.asList(HttpAttributes.HTTP_ROUTE, ServerAttributes.SERVER_PORT)));
    public static final Set<AttributeKey<?>> DEFAULT_HTTP_ATTRIBUTES_WITHOUT_ROUTE = Collections.singleton(ServerAttributes.SERVER_PORT);
    public static final SpanNameMapper DEFAULT_EXPECTED_SERVER_SPAN_NAME_MAPPER = (uri, method, route) -> {
        if ("_OTHER".equals(method)) {
            method = "HTTP";
        }
        return route == null ? method : method + " " + route;
    };
    Function<ServerEndpoint, Set<AttributeKey<?>>> httpAttributes = unused -> DEFAULT_HTTP_ATTRIBUTES;
    SpanNameMapper expectedServerSpanNameMapper = DEFAULT_EXPECTED_SERVER_SPAN_NAME_MAPPER;
    BiFunction<ServerEndpoint, String, String> expectedHttpRoute = (endpoint, method) -> null;
    Function<ServerEndpoint, String> sockPeerAddr = unused -> "127.0.0.1";
    String contextPath = "";
    Throwable expectedException;
    int responseCodeOnNonStandardHttpMethod;
    Predicate<ServerEndpoint> hasHandlerSpan;
    Predicate<ServerEndpoint> hasResponseSpan;
    Predicate<ServerEndpoint> hasRenderSpan;
    Predicate<ServerEndpoint> hasErrorPageSpans;
    Predicate<ServerEndpoint> hasResponseCustomizer;
    Predicate<ServerEndpoint> hasExceptionOnServerSpan;
    boolean testRedirect;
    boolean testError;
    boolean testErrorBody;
    boolean testException;
    boolean testNotFound;
    boolean testPathParam;
    boolean testCaptureHttpHeaders;
    boolean testCaptureRequestParameters;
    boolean testHttpPipelining;
    boolean testNonStandardHttpMethod;
    boolean verifyServerSpanEndTime;
    boolean useHttp2;

    HttpServerTestOptions() {
        this.expectedException = new IllegalStateException(ServerEndpoint.EXCEPTION.body);
        this.responseCodeOnNonStandardHttpMethod = ServerEndpoint.SUCCESS.status;
        this.hasHandlerSpan = unused -> false;
        this.hasResponseSpan = unused -> false;
        this.hasRenderSpan = unused -> false;
        this.hasErrorPageSpans = unused -> false;
        this.hasResponseCustomizer = unused -> false;
        this.hasExceptionOnServerSpan = endpoint -> !this.hasHandlerSpan.test((ServerEndpoint)endpoint);
        this.testRedirect = true;
        this.testError = true;
        this.testErrorBody = true;
        this.testException = true;
        this.testNotFound = true;
        this.testPathParam = false;
        this.testCaptureHttpHeaders = true;
        this.testCaptureRequestParameters = false;
        this.testHttpPipelining = true;
        this.testNonStandardHttpMethod = true;
        this.verifyServerSpanEndTime = true;
        this.useHttp2 = false;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHttpAttributes(Function<ServerEndpoint, Set<AttributeKey<?>>> httpAttributes) {
        this.httpAttributes = httpAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setExpectedServerSpanNameMapper(SpanNameMapper expectedServerSpanNameMapper) {
        this.expectedServerSpanNameMapper = expectedServerSpanNameMapper;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setExpectedHttpRoute(BiFunction<ServerEndpoint, String, String> expectedHttpRoute) {
        this.expectedHttpRoute = expectedHttpRoute;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setSockPeerAddr(Function<ServerEndpoint, String> sockPeerAddr) {
        this.sockPeerAddr = sockPeerAddr;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setExpectedException(Throwable expectedException) {
        this.expectedException = expectedException;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setResponseCodeOnNonStandardHttpMethod(int responseCodeOnNonStandardHttpMethod) {
        this.responseCodeOnNonStandardHttpMethod = responseCodeOnNonStandardHttpMethod;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasHandlerSpan(Predicate<ServerEndpoint> hasHandlerSpan) {
        this.hasHandlerSpan = hasHandlerSpan;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasResponseSpan(Predicate<ServerEndpoint> hasResponseSpan) {
        this.hasResponseSpan = hasResponseSpan;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasRenderSpan(Predicate<ServerEndpoint> hasRenderSpan) {
        this.hasRenderSpan = hasRenderSpan;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasErrorPageSpans(Predicate<ServerEndpoint> hasErrorPageSpans) {
        this.hasErrorPageSpans = hasErrorPageSpans;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasExceptionOnServerSpan(Predicate<ServerEndpoint> hasExceptionOnServerSpan) {
        this.hasExceptionOnServerSpan = hasExceptionOnServerSpan;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setHasResponseCustomizer(Predicate<ServerEndpoint> hasResponseCustomizer) {
        this.hasResponseCustomizer = hasResponseCustomizer;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestRedirect(boolean testRedirect) {
        this.testRedirect = testRedirect;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestError(boolean testError) {
        this.testError = testError;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestErrorBody(boolean testErrorBody) {
        this.testErrorBody = testErrorBody;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestException(boolean testException) {
        this.testException = testException;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestNotFound(boolean testNotFound) {
        this.testNotFound = testNotFound;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestPathParam(boolean testPathParam) {
        this.testPathParam = testPathParam;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestCaptureHttpHeaders(boolean testCaptureHttpHeaders) {
        this.testCaptureHttpHeaders = testCaptureHttpHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestCaptureRequestParameters(boolean testCaptureRequestParameters) {
        this.testCaptureRequestParameters = testCaptureRequestParameters;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setTestHttpPipelining(boolean testHttpPipelining) {
        this.testHttpPipelining = testHttpPipelining;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions disableTestNonStandardHttpMethod() {
        this.testNonStandardHttpMethod = false;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setVerifyServerSpanEndTime(boolean verifyServerSpanEndTime) {
        this.verifyServerSpanEndTime = verifyServerSpanEndTime;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions setUseHttp2(boolean useHttp2) {
        this.useHttp2 = useHttp2;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerTestOptions useHttp2() {
        return this.setUseHttp2(true);
    }

    @FunctionalInterface
    public static interface SpanNameMapper {
        public String apply(ServerEndpoint var1, String var2, @Nullable String var3);
    }
}

