/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.instrumentation.testing.junit.http.ServerEndpoint;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractHttpServerUsingTest<SERVER> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpServerUsingTest.class);
    public static final String TEST_CLIENT_IP = "1.1.1.1";
    public static final String TEST_USER_AGENT = "test-user-agent";
    InstrumentationTestRunner testing;
    private SERVER server;
    public WebClient client;
    public int port;
    public URI address;

    protected abstract SERVER setupServer() throws Exception;

    protected abstract void stopServer(SERVER var1) throws Exception;

    protected final InstrumentationTestRunner testing() {
        return this.testing;
    }

    protected void startServer() {
        if (this.address == null) {
            this.address = this.buildAddress();
        }
        try {
            this.server = this.setupServer();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to start server", exception);
        }
        if (this.server != null) {
            logger.info(this.getClass().getName() + " http server started at: http://localhost:" + this.port + this.getContextPath());
        }
    }

    protected abstract String getContextPath();

    protected void cleanupServer() {
        if (this.server == null) {
            logger.info(this.getClass().getName() + " can't stop null server");
            return;
        }
        try {
            this.stopServer(this.server);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to stop server", exception);
        }
        this.server = null;
        logger.info(this.getClass().getName() + " http server stopped at: http://localhost:" + this.port + "/");
    }

    protected URI buildAddress() {
        try {
            return new URI("http://localhost:" + this.port + this.getContextPath() + "/");
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @BeforeEach
    void verifyExtension() {
        if (this.testing == null) {
            throw new AssertionError((Object)"Subclasses of AbstractHttpServerUsingTest must register HttpServerInstrumentationExtension");
        }
    }

    protected String resolveAddress(ServerEndpoint uri) {
        return this.resolveAddress(uri, "h1c://");
    }

    protected String resolveAddress(ServerEndpoint uri, String protocolPrefix) {
        String url = uri.resolvePath(this.address).toString();
        url = url.replace("http://", protocolPrefix);
        if (uri.getQuery() != null) {
            url = url + "?" + uri.getQuery();
        }
        return url;
    }

    final void setTesting(InstrumentationTestRunner testing, WebClient client, int port) {
        this.setTesting(testing, client, port, null);
    }

    final void setTesting(InstrumentationTestRunner testing, WebClient client, int port, URI address) {
        this.testing = testing;
        this.client = client;
        this.port = port;
        this.address = address;
    }
}

