/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.testing.GlobalTraceUtil;
import io.opentelemetry.instrumentation.testing.junit.http.AbstractHttpServerUsingTest;
import io.opentelemetry.instrumentation.testing.junit.http.HttpServerTestOptions;
import io.opentelemetry.instrumentation.testing.junit.http.ServerEndpoint;
import io.opentelemetry.instrumentation.testing.util.ThrowingRunnable;
import io.opentelemetry.instrumentation.testing.util.ThrowingSupplier;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestBuilder;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.io.netty.bootstrap.Bootstrap;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelInitializer;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOption;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPipeline;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.MultiThreadIoEventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.SimpleChannelInboundHandler;
import io.opentelemetry.testing.internal.io.netty.channel.nio.NioIoHandler;
import io.opentelemetry.testing.internal.io.netty.channel.socket.SocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.nio.NioSocketChannel;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultHttpResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpClientCodec;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpMethod;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpObject;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AssertAccess;
import org.assertj.core.api.ThrowingConsumer;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractHttpServerTest<SERVER>
extends AbstractHttpServerUsingTest<SERVER> {
    public static final String TEST_REQUEST_HEADER = "X-Test-Request";
    public static final String TEST_RESPONSE_HEADER = "X-Test-Response";
    private final HttpServerTestOptions options = new HttpServerTestOptions();

    @BeforeAll
    void setupOptions() {
        this.options.expectedServerSpanNameMapper = this::expectedServerSpanName;
        this.options.expectedHttpRoute = this::expectedHttpRoute;
        this.configure(this.options);
        this.startServer();
    }

    @AfterAll
    void cleanup() {
        this.cleanupServer();
    }

    @Override
    protected final String getContextPath() {
        return this.options.contextPath;
    }

    protected void configure(HttpServerTestOptions options) {
    }

    public static <T, E extends Throwable> T controller(ServerEndpoint endpoint, ThrowingSupplier<T, E> closure) throws E {
        assert (Span.current().getSpanContext().isValid()) : "Controller should have a parent span.";
        if (endpoint == ServerEndpoint.NOT_FOUND) {
            return closure.get();
        }
        return GlobalTraceUtil.runWithSpan("controller", closure);
    }

    public static <E extends Throwable> void controller(ServerEndpoint endpoint, ThrowingRunnable<E> closure) throws E {
        AbstractHttpServerTest.controller(endpoint, () -> {
            closure.run();
            return null;
        });
    }

    protected AggregatedHttpRequest request(ServerEndpoint uri, String method) {
        return AggregatedHttpRequest.of(io.opentelemetry.testing.internal.armeria.common.HttpMethod.valueOf(method), this.resolveAddress(uri, this.getProtocolPrefix()));
    }

    private String getProtocolPrefix() {
        return this.options.useHttp2 ? "h2c://" : "h1c://";
    }

    @ParameterizedTest
    @ValueSource(ints={1, 4, 50})
    void successfulGetRequest(int count) {
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.SUCCESS, method);
        ArrayList<AggregatedHttpResponse> responses = new ArrayList<AggregatedHttpResponse>();
        for (int i = 0; i < count; ++i) {
            responses.add(this.client.execute(request).aggregate().join());
        }
        for (AggregatedHttpResponse response : responses) {
            OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
            OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
            this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, null);
        }
        this.assertTheTraces(count, null, null, null, method, ServerEndpoint.SUCCESS);
    }

    @Test
    void successfulGetRequestWithParent() {
        String method = "GET";
        String traceId = "00000000000000000000000000000123";
        String parentId = "0000000000000456";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().set((CharSequence)"tracePARENT", "00-" + traceId + "-" + parentId + "-01").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, traceId);
        this.assertTheTraces(1, traceId, parentId, spanId, "GET", ServerEndpoint.SUCCESS);
    }

    @Test
    void tracingHeaderIsCaseInsensitive() {
        String method = "GET";
        String traceId = "00000000000000000000000000000123";
        String parentId = "0000000000000456";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().set((CharSequence)"TRACEPARENT", "00-" + traceId + "-" + parentId + "-01").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, traceId);
        this.assertTheTraces(1, traceId, parentId, spanId, "GET", ServerEndpoint.SUCCESS);
    }

    @ParameterizedTest
    @MethodSource(value={"provideServerEndpoints"})
    void requestWithQueryString(ServerEndpoint endpoint) {
        String method = "GET";
        AggregatedHttpRequest request = this.request(endpoint, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(endpoint.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(endpoint.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, endpoint, null);
        this.assertTheTraces(1, null, null, spanId, method, endpoint);
    }

    private static Stream<ServerEndpoint> provideServerEndpoints() {
        return Stream.of(ServerEndpoint.SUCCESS, ServerEndpoint.QUERY_PARAM);
    }

    @Test
    void requestWithRedirect() {
        Assumptions.assumeTrue((boolean)this.options.testRedirect);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.REDIRECT, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.REDIRECT.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.headers().get("location")).satisfiesAnyOf(new ThrowingConsumer[]{location -> OpenTelemetryAssertions.assertThat((String)location).isEqualTo(ServerEndpoint.REDIRECT.getBody()), location -> OpenTelemetryAssertions.assertThat((String)new URI((String)location).normalize().toString()).isEqualTo(this.address.resolve(ServerEndpoint.REDIRECT.getBody()).toString())});
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.REDIRECT, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.REDIRECT);
    }

    @Test
    void requestWithError() {
        Assumptions.assumeTrue((boolean)this.options.testError);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.ERROR, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.ERROR.getStatus());
        if (this.options.testErrorBody) {
            OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.ERROR.getBody());
        }
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.ERROR, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void requestWithException() {
        Assumptions.assumeTrue((boolean)this.options.testException);
        Awaitility.doNotCatchUncaughtExceptionsByDefault();
        try {
            String method = "GET";
            AggregatedHttpRequest request = this.request(ServerEndpoint.EXCEPTION, method);
            AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
            OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.EXCEPTION.getStatus());
            String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.EXCEPTION, null);
            this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.EXCEPTION);
        }
        finally {
            Awaitility.reset();
        }
    }

    @Test
    void requestForNotFound() {
        Assumptions.assumeTrue((boolean)this.options.testNotFound);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.NOT_FOUND, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.NOT_FOUND.getStatus());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.NOT_FOUND, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.NOT_FOUND);
    }

    @Test
    void requestWithPathParameter() {
        Assumptions.assumeTrue((boolean)this.options.testPathParam);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.PATH_PARAM, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.PATH_PARAM.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.PATH_PARAM.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.PATH_PARAM, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.PATH_PARAM);
    }

    @Test
    void captureHttpHeaders() {
        Assumptions.assumeTrue((boolean)this.options.testCaptureHttpHeaders);
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.CAPTURE_HEADERS, "GET").headers().toBuilder().add((CharSequence)TEST_REQUEST_HEADER, "test").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.CAPTURE_HEADERS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.CAPTURE_HEADERS.getBody());
        OpenTelemetryAssertions.assertThat((String)response.headers().get(TEST_RESPONSE_HEADER)).isEqualTo("test");
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.CAPTURE_HEADERS, null);
        this.assertTheTraces(1, null, null, spanId, "GET", ServerEndpoint.CAPTURE_HEADERS);
    }

    @Test
    void captureRequestParameters() {
        Assumptions.assumeTrue((boolean)this.options.testCaptureRequestParameters);
        QueryParams formBody = QueryParams.builder().add("test-parameter", "test value \u00f5\u00e4\u00f6\u00fc").build();
        AggregatedHttpRequest request = AggregatedHttpRequest.of(RequestHeaders.builder(io.opentelemetry.testing.internal.armeria.common.HttpMethod.POST, this.resolveAddress(ServerEndpoint.CAPTURE_PARAMETERS, this.getProtocolPrefix())).contentType(MediaType.FORM_DATA).build(), HttpData.ofUtf8(formBody.toQueryString()));
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.CAPTURE_PARAMETERS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.CAPTURE_PARAMETERS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.CAPTURE_PARAMETERS, null);
        this.assertTheTraces(1, null, null, spanId, "POST", ServerEndpoint.CAPTURE_PARAMETERS);
    }

    @Test
    void httpServerMetrics() {
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.SUCCESS, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        AtomicReference instrumentationName = new AtomicReference();
        this.testing.waitAndAssertTraces(trace -> {
            instrumentationName.set(trace.getSpan(0).getInstrumentationScopeInfo().getName());
            trace.anySatisfy(spanData -> this.assertServerSpan(OpenTelemetryAssertions.assertThat((SpanData)spanData), method, ServerEndpoint.SUCCESS, ServerEndpoint.SUCCESS.status));
        });
        this.testing.waitAndAssertMetrics((String)instrumentationName.get(), "http.server.request.duration", metrics -> metrics.anySatisfy(metric -> OpenTelemetryAssertions.assertThat((MetricData)metric).hasDescription("Duration of HTTP server requests.").hasUnit("s").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasSumGreaterThan(0.0)}))));
    }

    @Test
    void highConcurrency() throws InterruptedException {
        int count = 100;
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        CountDownLatch latch = new CountDownLatch(count);
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        TextMapSetter setter = HttpRequestBuilder::header;
        ArrayList responses = new ArrayList();
        int i = 0;
        while (i < count) {
            int index = i++;
            HttpRequestBuilder request = HttpRequest.builder().get(endpoint.resolvePath(this.address).toString().replace("http://", this.getProtocolPrefix())).queryParam("id", index);
            this.testing.runWithSpan("client " + index, () -> {
                Span.current().setAttribute("test.request.id", (long)index);
                propagator.inject(Context.current(), (Object)request, setter);
                this.client.execute(request.build()).aggregate().whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        responses.add(throwable.toString());
                    } else {
                        responses.add(result.status().code() + " " + result.contentUtf8());
                    }
                    latch.countDown();
                });
            });
        }
        latch.await();
        OpenTelemetryAssertions.assertThat(responses).allSatisfy(response -> OpenTelemetryAssertions.assertThat((String)response).isEqualTo(endpoint.getStatus() + " " + endpoint.getBody()));
        this.assertHighConcurrency(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void httpPipelining() throws InterruptedException {
        Assumptions.assumeTrue((boolean)this.options.testHttpPipelining);
        Assumptions.assumeFalse((boolean)this.options.useHttp2);
        int count = 10;
        final CountDownLatch countDownLatch = new CountDownLatch(count);
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        TextMapSetter setter = (request, key, value) -> request.headers().set(key, (Object)value);
        MultiThreadIoEventLoopGroup eventLoopGroup = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap bootstrap = AbstractHttpServerTest.buildBootstrap(eventLoopGroup);
            Channel channel = bootstrap.connect(this.address.getHost(), this.port).sync().channel();
            channel.pipeline().addLast(new SimpleChannelInboundHandler<HttpObject>(){

                @Override
                protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                    if (httpObject instanceof DefaultHttpResponse) {
                        countDownLatch.countDown();
                    }
                }
            });
            int i = 0;
            while (i < count) {
                int index = i++;
                String target = endpoint.resolvePath(this.address).getPath().toString() + "?" + "id" + "=" + index;
                this.testing.runWithSpan("client " + index, () -> {
                    Span.current().setAttribute("test.request.id", (long)index);
                    DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf("GET"), target, Unpooled.EMPTY_BUFFER);
                    request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(this.address.getHost() + ":" + this.port));
                    request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"test-user-agent");
                    request.headers().set((CharSequence)HttpHeaderNames.X_FORWARDED_FOR, (Object)"1.1.1.1");
                    propagator.inject(Context.current(), (Object)request, setter);
                    channel.writeAndFlush(request);
                });
            }
            countDownLatch.await(30L, TimeUnit.SECONDS);
            this.assertHighConcurrency(count);
        }
        finally {
            eventLoopGroup.shutdownGracefully().await(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void requestWithNonStandardHttpMethod() throws InterruptedException {
        Assumptions.assumeTrue((boolean)this.options.testNonStandardHttpMethod);
        Assumptions.assumeFalse((boolean)this.options.useHttp2);
        MultiThreadIoEventLoopGroup eventLoopGroup = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap bootstrap = AbstractHttpServerTest.buildBootstrap(eventLoopGroup);
            Channel channel = bootstrap.connect(this.address.getHost(), this.port).sync().channel();
            String method = "TEST";
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, new HttpMethod(method), ServerEndpoint.SUCCESS.resolvePath(this.address).getPath(), Unpooled.EMPTY_BUFFER);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(this.address.getHost() + ":" + this.port));
            request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"test-user-agent");
            request.headers().set((CharSequence)HttpHeaderNames.X_FORWARDED_FOR, (Object)"1.1.1.1");
            this.testing.getOpenTelemetry().getPropagators().getTextMapPropagator().inject(Context.current(), (Object)request, (carrier, key, value) -> carrier.headers().set(key, (Object)value));
            channel.writeAndFlush(request);
            this.testing.waitAndAssertTraces(trace -> trace.anySatisfy(span -> this.assertServerSpan(OpenTelemetryAssertions.assertThat((SpanData)span), "_OTHER", ServerEndpoint.SUCCESS, this.options.responseCodeOnNonStandardHttpMethod).hasAttribute(HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL, (Object)method)));
        }
        finally {
            eventLoopGroup.shutdownGracefully().await(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    void extractSingleBaggage() {
        String method = "GET";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().set((CharSequence)"baggage", "test-baggage-key-1=test-baggage-value-1").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        this.testing.waitAndAssertTraces(trace -> trace.anySatisfy(span -> this.assertServerSpan(OpenTelemetryAssertions.assertThat((SpanData)span), method, ServerEndpoint.SUCCESS, ServerEndpoint.SUCCESS.status).hasAttribute(AttributeKey.stringKey((String)"test-baggage-key-1"), (Object)"test-baggage-value-1")));
    }

    @Test
    void extractMultiBaggage() {
        String method = "GET";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().add((CharSequence)"baggage", "test-baggage-key-1=test-baggage-value-1").add((CharSequence)"baggage", "test-baggage-key-2=test-baggage-value-2").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        this.testing.waitAndAssertTraces(trace -> trace.anySatisfy(span -> this.assertServerSpan(OpenTelemetryAssertions.assertThat((SpanData)span), method, ServerEndpoint.SUCCESS, ServerEndpoint.SUCCESS.status).hasAttribute(AttributeKey.stringKey((String)"test-baggage-key-1"), (Object)"test-baggage-value-1").hasAttribute(AttributeKey.stringKey((String)"test-baggage-key-2"), (Object)"test-baggage-value-2")));
    }

    private static Bootstrap buildBootstrap(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)TimeUnit.SECONDS.toMillis(10L))).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new HttpClientCodec());
            }
        });
        return bootstrap;
    }

    protected void assertHighConcurrency(int count) {
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        ArrayList<Consumer<TraceAssert>> assertions = new ArrayList<Consumer<TraceAssert>>();
        for (int i = 0; i < count; ++i) {
            assertions.add(trace -> {
                SpanData rootSpan = trace.getSpan(0);
                int requestId = Integer.parseInt(rootSpan.getName().substring("client ".length()));
                ArrayList<Consumer<SpanDataAssert>> spanAssertions = new ArrayList<Consumer<SpanDataAssert>>();
                spanAssertions.add(span -> span.hasName(rootSpan.getName()).hasKind(SpanKind.INTERNAL).hasNoParent().hasAttributesSatisfyingExactly(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)AttributeKey.longKey((String)"test.request.id"), (int)requestId)}));
                spanAssertions.add(span -> this.assertIndexedServerSpan((SpanDataAssert)span, requestId).hasParent(rootSpan));
                if (this.options.hasHandlerSpan.test(endpoint)) {
                    spanAssertions.add(span -> this.assertHandlerSpan((SpanDataAssert)span, "GET", endpoint).hasParent(trace.getSpan(1)));
                }
                int parentIndex = spanAssertions.size() - 1;
                spanAssertions.add(span -> this.assertIndexedControllerSpan((SpanDataAssert)span, requestId).hasParent(trace.getSpan(parentIndex)));
                trace.hasSpansSatisfyingExactly(spanAssertions);
            });
        }
        this.testing.waitAndAssertTraces(assertions);
    }

    protected String assertResponseHasCustomizedHeaders(AggregatedHttpResponse response, ServerEndpoint endpoint, String expectedTraceId) {
        if (!this.options.hasResponseCustomizer.test(endpoint)) {
            return null;
        }
        String responseHeaderTraceId = response.headers().get("x-test-traceid");
        String responseHeaderSpanId = response.headers().get("x-test-spanid");
        if (expectedTraceId != null) {
            OpenTelemetryAssertions.assertThat((String)responseHeaderTraceId).matches((CharSequence)expectedTraceId);
        } else {
            OpenTelemetryAssertions.assertThat((String)responseHeaderTraceId).isNotNull();
        }
        OpenTelemetryAssertions.assertThat((String)responseHeaderSpanId).isNotNull();
        return responseHeaderSpanId;
    }

    protected void assertTheTraces(int size, String traceId, String parentId, String spanId, String method, ServerEndpoint endpoint) {
        ArrayList<Consumer<TraceAssert>> assertions = new ArrayList<Consumer<TraceAssert>>();
        for (int i = 0; i < size; ++i) {
            assertions.add(trace -> {
                List spanData;
                int parentIndex;
                ArrayList<Consumer<SpanDataAssert>> spanAssertions = new ArrayList<Consumer<SpanDataAssert>>();
                spanAssertions.add(span -> {
                    this.assertServerSpan((SpanDataAssert)span, method, endpoint, endpoint.status);
                    if (traceId != null) {
                        span.hasTraceId(traceId);
                    }
                    if (spanId != null) {
                        span.hasSpanId(spanId);
                    }
                    if (parentId != null) {
                        span.hasParentSpanId(parentId);
                    } else {
                        span.hasNoParent();
                    }
                });
                if (this.options.hasHandlerSpan.test(endpoint)) {
                    spanAssertions.add(span -> {
                        this.assertHandlerSpan((SpanDataAssert)span, method, endpoint);
                        span.hasParent(trace.getSpan(0));
                    });
                }
                if (endpoint != ServerEndpoint.NOT_FOUND) {
                    parentIndex = 0;
                    if (this.options.hasHandlerSpan.test(endpoint)) {
                        parentIndex = spanAssertions.size() - 1;
                    }
                    int finalParentIndex = parentIndex;
                    spanAssertions.add(span -> {
                        this.assertControllerSpan((SpanDataAssert)span, endpoint == ServerEndpoint.EXCEPTION ? this.options.expectedException : null);
                        span.hasParent(trace.getSpan(finalParentIndex));
                    });
                    if (this.options.hasRenderSpan.test(endpoint)) {
                        spanAssertions.add(span -> this.assertRenderSpan((SpanDataAssert)span, method, endpoint));
                    }
                }
                if (this.options.hasResponseSpan.test(endpoint)) {
                    parentIndex = spanAssertions.size() - 1;
                    spanAssertions.add(span -> this.assertResponseSpan((SpanDataAssert)span, trace.getSpan(parentIndex), trace.getSpan(0), method, endpoint));
                }
                if (this.options.hasErrorPageSpans.test(endpoint)) {
                    spanAssertions.addAll(this.errorPageSpanAssertions(method, endpoint));
                }
                trace.hasSpansSatisfyingExactly(spanAssertions);
                if (this.options.verifyServerSpanEndTime && (spanData = (List)AssertAccess.getActual(trace)).size() > 1) {
                    SpanData rootSpan = (SpanData)spanData.get(0);
                    for (int j = 1; j < spanData.size(); ++j) {
                        OpenTelemetryAssertions.assertThat((long)rootSpan.getEndEpochNanos()).isGreaterThanOrEqualTo(((SpanData)spanData.get(j)).getEndEpochNanos());
                    }
                }
            });
        }
        this.testing.waitAndAssertTraces(assertions);
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertControllerSpan(SpanDataAssert span, Throwable expectedException) {
        span.hasName("controller").hasKind(SpanKind.INTERNAL);
        if (expectedException != null) {
            span.hasStatus(StatusData.error());
            span.hasException(expectedException);
        }
        return span;
    }

    protected SpanDataAssert assertHandlerSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("assertHandlerSpan not implemented in " + this.getClass().getName());
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertResponseSpan(SpanDataAssert span, SpanData controllerSpan, SpanData handlerSpan, String method, ServerEndpoint endpoint) {
        return this.assertResponseSpan(span, controllerSpan, method, endpoint);
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertResponseSpan(SpanDataAssert span, SpanData parentSpan, String method, ServerEndpoint endpoint) {
        span.hasParent(parentSpan);
        return this.assertResponseSpan(span, method, endpoint);
    }

    protected SpanDataAssert assertResponseSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("assertResponseSpan not implemented in " + this.getClass().getName());
    }

    protected SpanDataAssert assertRenderSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("assertRenderSpan not implemented in " + this.getClass().getName());
    }

    protected List<Consumer<SpanDataAssert>> errorPageSpanAssertions(String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("errorPageSpanAssertions not implemented in " + this.getClass().getName());
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertServerSpan(SpanDataAssert span, String method, ServerEndpoint endpoint, int statusCode) {
        Set<AttributeKey<?>> httpAttributes = this.options.httpAttributes.apply(endpoint);
        String expectedRoute = this.options.expectedHttpRoute.apply(endpoint, method);
        String name = this.options.expectedServerSpanNameMapper.apply(endpoint, method, expectedRoute);
        span.hasName(name).hasKind(SpanKind.SERVER);
        if (statusCode >= 500) {
            span.hasStatus(StatusData.error());
        }
        if (endpoint == ServerEndpoint.EXCEPTION && this.options.hasExceptionOnServerSpan.test(endpoint)) {
            span.hasException(this.options.expectedException);
        }
        span.hasAttributesSatisfying(attrs -> {
            OpenTelemetryAssertions.assertThat((Attributes)attrs).doesNotContainKey(NetworkAttributes.NETWORK_TRANSPORT).doesNotContainKey(NetworkAttributes.NETWORK_TYPE).doesNotContainKey(NetworkAttributes.NETWORK_PROTOCOL_NAME);
            if (attrs.get(NetworkAttributes.NETWORK_PROTOCOL_VERSION) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)(this.options.useHttp2 ? "2" : "1.1"));
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(ServerAttributes.SERVER_ADDRESS, (Object)"localhost");
            if (attrs.get(ServerAttributes.SERVER_PORT) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(ServerAttributes.SERVER_PORT, this.port);
            }
            if (attrs.get(NetworkAttributes.NETWORK_PEER_ADDRESS) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(NetworkAttributes.NETWORK_PEER_ADDRESS, (Object)this.options.sockPeerAddr.apply(endpoint));
            }
            if (attrs.get(NetworkAttributes.NETWORK_PEER_PORT) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(NetworkAttributes.NETWORK_PEER_PORT, value -> ((AbstractLongAssert)OpenTelemetryAssertions.assertThat((Long)value).isInstanceOf(Long.class)).isNotEqualTo((Object)this.port));
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(ClientAttributes.CLIENT_ADDRESS, (Object)"1.1.1.1");
            OpenTelemetryAssertions.assertThat((Attributes)attrs).doesNotContainKey(ClientAttributes.CLIENT_PORT);
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(HttpAttributes.HTTP_REQUEST_METHOD, (Object)method);
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode);
            if (statusCode >= 500) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(ErrorAttributes.ERROR_TYPE, (Object)String.valueOf(statusCode));
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UserAgentAttributes.USER_AGENT_ORIGINAL, (Object)"test-user-agent");
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UrlAttributes.URL_SCHEME, (Object)"http");
            if (endpoint != ServerEndpoint.INDEXED_CHILD) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UrlAttributes.URL_PATH, (Object)endpoint.resolvePath(this.address).getPath());
                if (endpoint.getQuery() != null) {
                    OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UrlAttributes.URL_QUERY, (Object)endpoint.getQuery());
                }
            }
            if (httpAttributes.contains(HttpAttributes.HTTP_ROUTE) && expectedRoute != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(HttpAttributes.HTTP_ROUTE, (Object)expectedRoute);
            }
            if (endpoint == ServerEndpoint.CAPTURE_HEADERS) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("http.request.header.x-test-request", new String[]{"test"});
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("http.response.header.x-test-response", new String[]{"test"});
            }
            if (endpoint == ServerEndpoint.CAPTURE_PARAMETERS) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("servlet.request.parameter.test-parameter", new String[]{"test value \u00f5\u00e4\u00f6\u00fc"});
            }
        });
        return span;
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertIndexedServerSpan(SpanDataAssert span, int requestId) {
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        String method = "GET";
        return this.assertServerSpan(span, method, endpoint, endpoint.status).hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)UrlAttributes.URL_PATH, (Object)endpoint.resolvePath(this.address).getPath()), OpenTelemetryAssertions.equalTo((AttributeKey)UrlAttributes.URL_QUERY, (Object)("id=" + requestId))});
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertIndexedControllerSpan(SpanDataAssert span, int requestId) {
        span.hasName("controller").hasKind(SpanKind.INTERNAL).hasAttributesSatisfyingExactly(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)AttributeKey.longKey((String)"test.request.id"), (int)requestId)});
        return span;
    }

    public String expectedServerSpanName(ServerEndpoint endpoint, String method, @Nullable String route) {
        return HttpServerTestOptions.DEFAULT_EXPECTED_SERVER_SPAN_NAME_MAPPER.apply(endpoint, method, route);
    }

    public final boolean hasHttpRouteAttribute(ServerEndpoint endpoint) {
        return this.options.httpAttributes.apply(endpoint).contains(HttpAttributes.HTTP_ROUTE);
    }

    public final boolean hasHandlerSpan(ServerEndpoint endpoint) {
        return this.options.hasHandlerSpan.test(endpoint);
    }

    public String expectedHttpRoute(ServerEndpoint endpoint, String method) {
        if (!this.hasHttpRouteAttribute(endpoint)) {
            return null;
        }
        if ("_OTHER".equals(method)) {
            return null;
        }
        if (ServerEndpoint.NOT_FOUND.equals(endpoint)) {
            return null;
        }
        if (ServerEndpoint.PATH_PARAM.equals(endpoint)) {
            return this.options.contextPath + "/path/:id/param";
        }
        return endpoint.resolvePath(this.address).getPath();
    }
}

