/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.DbAttributes;
import io.opentelemetry.semconv.incubating.CassandraIncubatingAttributes;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import java.util.HashMap;
import java.util.Map;

public class SemconvStabilityUtil {
    private static final Map<AttributeKey<?>, AttributeKey<?>> oldToNewMap = SemconvStabilityUtil.buildMap();

    private static Map<AttributeKey<?>, AttributeKey<?>> buildMap() {
        HashMap map = new HashMap();
        map.put(DbIncubatingAttributes.DB_NAME, DbAttributes.DB_NAMESPACE);
        map.put(DbIncubatingAttributes.DB_STATEMENT, DbAttributes.DB_QUERY_TEXT);
        map.put(DbIncubatingAttributes.DB_OPERATION, DbAttributes.DB_OPERATION_NAME);
        map.put(DbIncubatingAttributes.DB_SQL_TABLE, DbAttributes.DB_COLLECTION_NAME);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_TABLE, DbAttributes.DB_COLLECTION_NAME);
        map.put(DbIncubatingAttributes.DB_MONGODB_COLLECTION, DbAttributes.DB_COLLECTION_NAME);
        map.put(DbIncubatingAttributes.DB_SYSTEM, DbAttributes.DB_SYSTEM_NAME);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_CONSISTENCY_LEVEL, CassandraIncubatingAttributes.CASSANDRA_CONSISTENCY_LEVEL);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_COORDINATOR_DC, CassandraIncubatingAttributes.CASSANDRA_COORDINATOR_DC);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_COORDINATOR_ID, CassandraIncubatingAttributes.CASSANDRA_COORDINATOR_ID);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_IDEMPOTENCE, CassandraIncubatingAttributes.CASSANDRA_QUERY_IDEMPOTENT);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_PAGE_SIZE, CassandraIncubatingAttributes.CASSANDRA_PAGE_SIZE);
        map.put(DbIncubatingAttributes.DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT, CassandraIncubatingAttributes.CASSANDRA_SPECULATIVE_EXECUTION_COUNT);
        return map;
    }

    private SemconvStabilityUtil() {
    }

    public static <T> AttributeKey<T> maybeStable(AttributeKey<T> oldKey) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            return oldToNewMap.get(oldKey);
        }
        return oldKey;
    }

    public static String maybeStableDbSystemName(String oldDbSystemName) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            return SemconvStability.stableDbSystemName((String)oldDbSystemName);
        }
        return oldDbSystemName;
    }
}

