/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.internal;

import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MetaDataCollector {
    private static final String TMP_DIR = ".telemetry";
    private static final Pattern MODULE_PATTERN = Pattern.compile("(.*?/instrumentation/.*?)(/javaagent/|/library/)");

    public static void writeTelemetryToFiles(String path, Map<InstrumentationScopeInfo, Map<String, MetricData>> metricsByScope, Map<InstrumentationScopeInfo, Map<SpanKind, Map<InternalAttributeKeyImpl<?>, AttributeType>>> spansByScopeAndKind) throws IOException {
        String moduleRoot = MetaDataCollector.extractInstrumentationPath(path);
        MetaDataCollector.writeMetricData(moduleRoot, metricsByScope);
        MetaDataCollector.writeSpanData(moduleRoot, spansByScopeAndKind);
    }

    private static String extractInstrumentationPath(String path) {
        Matcher matcher = MODULE_PATTERN.matcher(path);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String instrumentationPath = matcher.group(1);
        Path telemetryDir = Paths.get(instrumentationPath, TMP_DIR);
        try {
            Files.createDirectories(telemetryDir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return instrumentationPath;
    }

    private static void writeSpanData(String instrumentationPath, Map<InstrumentationScopeInfo, Map<SpanKind, Map<InternalAttributeKeyImpl<?>, AttributeType>>> spansByScopeAndKind) throws IOException {
        if (spansByScopeAndKind.isEmpty()) {
            return;
        }
        Path spansPath = Paths.get(instrumentationPath, TMP_DIR, "spans-" + UUID.randomUUID() + ".yaml");
        try (BufferedWriter writer = Files.newBufferedWriter(spansPath.toFile().toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String config = System.getProperty("metadataConfig");
            String when = "default";
            if (config != null && !config.isEmpty()) {
                when = config;
            }
            writer.write("when: " + when + "\n");
            writer.write("spans_by_scope:\n");
            for (Map.Entry<InstrumentationScopeInfo, Map<SpanKind, Map<InternalAttributeKeyImpl<?>, AttributeType>>> entry : spansByScopeAndKind.entrySet()) {
                InstrumentationScopeInfo scope = entry.getKey();
                Map<SpanKind, Map<InternalAttributeKeyImpl<?>, AttributeType>> spansByKind = entry.getValue();
                writer.write("  - scope: " + scope.getName() + "\n");
                writer.write("    spans:\n");
                for (Map.Entry<SpanKind, Map<InternalAttributeKeyImpl<?>, AttributeType>> kindEntry : spansByKind.entrySet()) {
                    SpanKind spanKind = kindEntry.getKey();
                    Map<InternalAttributeKeyImpl<?>, AttributeType> attributes = kindEntry.getValue();
                    writer.write("      - span_kind: " + spanKind.toString() + "\n");
                    writer.write("        attributes:\n");
                    attributes.forEach((key, value) -> {
                        try {
                            writer.write("          - name: " + key.getKey() + "\n");
                            writer.write("            type: " + key.getType().toString() + "\n");
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
            }
        }
    }

    private static void writeMetricData(String instrumentationPath, Map<InstrumentationScopeInfo, Map<String, MetricData>> metricsByScope) throws IOException {
        if (metricsByScope.isEmpty()) {
            return;
        }
        Path metricsPath = Paths.get(instrumentationPath, TMP_DIR, "metrics-" + UUID.randomUUID() + ".yaml");
        try (BufferedWriter writer = Files.newBufferedWriter(metricsPath.toFile().toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            String config = System.getProperty("metadataConfig");
            String when = "default";
            if (config != null && !config.isEmpty()) {
                when = config;
            }
            writer.write("when: " + when + "\n");
            writer.write("metrics_by_scope:\n");
            for (Map.Entry<InstrumentationScopeInfo, Map<String, MetricData>> entry : metricsByScope.entrySet()) {
                InstrumentationScopeInfo scope = entry.getKey();
                Map<String, MetricData> metrics = entry.getValue();
                writer.write("  - scope: " + scope.getName() + "\n");
                writer.write("    metrics:\n");
                for (MetricData metric : metrics.values()) {
                    writer.write("      - name: " + metric.getName() + "\n");
                    writer.write("        description: " + metric.getDescription() + "\n");
                    writer.write("        type: " + metric.getType().toString() + "\n");
                    writer.write("        unit: " + MetaDataCollector.sanitizeUnit(metric.getUnit()) + "\n");
                    writer.write("        attributes: \n");
                    ((PointData)metric.getData().getPoints().stream().findFirst().get()).getAttributes().forEach((key, value) -> {
                        try {
                            writer.write("          - name: " + key.getKey() + "\n");
                            writer.write("            type: " + key.getType().toString() + "\n");
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
            }
        }
    }

    private static String sanitizeUnit(String unit) {
        return unit == null ? null : unit.replace("{", "").replace("}", "");
    }

    private MetaDataCollector() {
    }
}

