/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.base;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.instrumentation.test.InstrumentationSpecification;
import io.opentelemetry.instrumentation.test.asserts.TraceAssert;
import io.opentelemetry.instrumentation.testing.junit.http.AbstractHttpClientTest;
import io.opentelemetry.instrumentation.testing.junit.http.HttpClientResult;
import io.opentelemetry.instrumentation.testing.junit.http.HttpClientTestOptions;
import io.opentelemetry.instrumentation.testing.junit.http.HttpClientTestServer;
import io.opentelemetry.instrumentation.testing.junit.http.SingleConnection;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.junit.jupiter.api.Assumptions;
import org.spockframework.runtime.ErrorCollector;
import org.spockframework.runtime.ErrorRethrower;
import org.spockframework.runtime.SpockRuntime;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.BlockKind;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.DataProcessorMetadata;
import org.spockframework.runtime.model.DataProviderMetadata;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Requires;
import spock.lang.Shared;
import spock.lang.Specification;
import spock.lang.Unroll;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Unroll
@SpecMetadata(filename="HttpClientTest.groovy", line=26)
public abstract class HttpClientTest<REQUEST>
extends InstrumentationSpecification {
    protected static final Object BODY_METHODS;
    protected static final Object CONNECT_TIMEOUT_MS;
    protected static final Object READ_TIMEOUT_MS;
    @Shared
    @FieldMetadata(initializer=true, line=110, name="junitTest", ordinal=0)
    protected volatile Object $spock_sharedField_junitTest;
    @Shared
    @FieldMetadata(initializer=false, line=151, name="server", ordinal=1)
    protected volatile HttpClientTestServer $spock_sharedField_server;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public HttpClientTest() {
    }

    public abstract REQUEST buildRequest(String var1, URI var2, Map<String, String> var3);

    public abstract int sendRequest(REQUEST var1, String var2, URI var3, Map<String, String> var4);

    public void sendRequestWithCallback(REQUEST request, String method, URI uri, Map<String, String> headers, HttpClientResult requestResult) {
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, UnsupportedOperationException.class));
    }

    private Object setupSpec() {
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, HttpClientTestServer.class, IndyInterface.bootstrap("getProperty", "openTelemetry", 12, this));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, HttpClientTest.class, (GroovyObject)this, (String)"server");
        IndyInterface.bootstrap("invoke", "start", 0, IndyInterface.bootstrap("getProperty", "server", 12, this));
        IndyInterface.bootstrap("invoke", "setupOptions", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this));
        return IndyInterface.bootstrap("invoke", "setTesting", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this), IndyInterface.bootstrap("invoke", "testRunner", 2, this), IndyInterface.bootstrap("getProperty", "server", 12, this));
    }

    private Object cleanupSpec() {
        return IndyInterface.bootstrap("invoke", "stop", 0, IndyInterface.bootstrap("getProperty", "server", 12, this));
    }

    public Object http client span ends after headers are received() {
        return IndyInterface.bootstrap("invoke", "spanEndsAfterHeadersReceived", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this));
    }

    public final int doRequest(String method, URI uri, Map<String, String> headers) {
        CallSite request = IndyInterface.bootstrap("invoke", "buildRequest", 2, this, method, uri, headers);
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "sendRequest", 2, this, request, method, uri, headers));
    }

    protected String expectedClientSpanName(URI uri, String method) {
        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "_OTHER", 0, HttpConstants.class), (Object)method) ? "HTTP" : method;
    }

    public Integer responseCodeOnRedirectError() {
        return 302;
    }

    public Set<AttributeKey<?>> httpAttributes(URI uri) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, IndyInterface.bootstrap("getProperty", "DEFAULT_HTTP_ATTRIBUTES", 0, HttpClientTestOptions.class)));
    }

    public SingleConnection createSingleConnection(String host, int port) {
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public boolean testWithClientParent() {
        return true;
    }

    public boolean testRedirects() {
        return true;
    }

    public boolean testCircularRedirects() {
        return true;
    }

    public int maxRedirects() {
        return 2;
    }

    public boolean testReusedRequest() {
        return true;
    }

    public boolean testCapturedHttpHeaders() {
        return true;
    }

    public boolean testConnectionFailure() {
        return true;
    }

    public boolean testRemoteConnection() {
        return true;
    }

    public boolean testReadTimeout() {
        return true;
    }

    public boolean testHttps() {
        return true;
    }

    public boolean testCallback() {
        return true;
    }

    public boolean testCallbackWithParent() {
        return true;
    }

    public boolean testErrorWithCallback() {
        return true;
    }

    public boolean testNonStandardHttpMethod() {
        return true;
    }

    public Throwable clientSpanError(URI uri, Throwable exception) {
        return exception;
    }

    public final void clientSpan(TraceAssert trace, int index, Object parentSpan, String method, URI uri, Integer responseCode) {
        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "assertedIndexes", 4, trace), index);
        CallSite spanData = IndyInterface.bootstrap("invoke", "span", 0, trace, index);
        CallSite assertion = IndyInterface.bootstrap("invoke", "assertClientSpan", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this), IndyInterface.bootstrap("invoke", "assertThat", 0, OpenTelemetryAssertions.class, spanData), uri, method, responseCode, null);
        if (ScriptBytecodeAdapter.compareEqual((Object)parentSpan, null)) {
            IndyInterface.bootstrap("invoke", "hasParentSpanId", 0, assertion, IndyInterface.bootstrap("getProperty", "invalid", 0, SpanId.class));
        } else {
            IndyInterface.bootstrap("invoke", "hasParentSpanId", 0, assertion, IndyInterface.bootstrap("getProperty", "spanId", 0, IndyInterface.bootstrap("cast", "()", 0, parentSpan)));
        }
    }

    public final void serverSpan(TraceAssert trace, int index, Object parentSpan) {
        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "assertedIndexes", 4, trace), index);
        CallSite spanData = IndyInterface.bootstrap("invoke", "span", 0, trace, index);
        CallSite assertion = IndyInterface.bootstrap("invoke", "assertServerSpan", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this), IndyInterface.bootstrap("invoke", "assertThat", 0, OpenTelemetryAssertions.class, spanData));
        if (ScriptBytecodeAdapter.compareEqual((Object)parentSpan, null)) {
            IndyInterface.bootstrap("invoke", "hasParentSpanId", 0, assertion, IndyInterface.bootstrap("getProperty", "invalid", 0, SpanId.class));
        } else {
            IndyInterface.bootstrap("invoke", "hasParentSpanId", 0, assertion, IndyInterface.bootstrap("getProperty", "spanId", 0, IndyInterface.bootstrap("cast", "()", 0, parentSpan)));
        }
    }

    public final URI resolveAddress(String path) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveAddress", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this), path));
    }

    public /* synthetic */ Object getJunitTest() {
        return ScriptBytecodeAdapter.getField(HttpClientTest.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getSharedInstance(), (String)"$spock_sharedField_junitTest");
    }

    public /* synthetic */ void setJunitTest(Object $spock_value) {
        Object object = $spock_value;
        ScriptBytecodeAdapter.setField((Object)object, HttpClientTest.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getSharedInstance(), (String)"$spock_sharedField_junitTest");
    }

    private /* synthetic */ Object $spock_initializeSharedFields() {
        1 var1_1 = new 1(this);
        this.$spock_sharedField_junitTest = var1_1;
        return var1_1;
    }

    public /* synthetic */ HttpClientTestServer getServer() {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(HttpClientTest.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getSharedInstance(), (String)"$spock_sharedField_server"));
    }

    public /* synthetic */ void setServer(HttpClientTestServer $spock_value) {
        HttpClientTestServer httpClientTestServer = $spock_value;
        ScriptBytecodeAdapter.setField((Object)httpClientTestServer, HttpClientTest.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getSharedInstance(), (String)"$spock_sharedField_server");
    }

    @FeatureMetadata(line=165, name="basic GET request #path", ordinal=0, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={}), @BlockMetadata(kind=BlockKind.WHERE, texts={})}, parameterNames={"path"})
    public void $spock_feature_1_0(Object path) {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.successfulGetRequest(path)", (int)167, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "successfulGetRequest"))), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(2), path)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(5, false)), (boolean)false, (int)4);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.successfulGetRequest(path)", (int)167, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @DataProviderMetadata(line=170, dataVariables={"path"})
    public /* synthetic */ Object $spock_feature_1_0prov0() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{"/success", "/success?with=params"});
    }

    @DataProcessorMetadata(dataVariables={"path"})
    public /* synthetic */ Object $spock_feature_1_0proc(Object $spock_p0) {
        Object path = $spock_p0;
        return new Object[]{path};
    }

    @FeatureMetadata(line=173, name="request with non-standard http method", ordinal=1, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_1() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testNonStandardHttpMethod", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.requestWithNonStandardHttpMethod()", (int)176, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "requestWithNonStandardHttpMethod"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.requestWithNonStandardHttpMethod()", (int)176, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=179, name="basic #method request with parent", ordinal=2, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={}), @BlockMetadata(kind=BlockKind.WHERE, texts={})}, parameterNames={"method"})
    public void $spock_feature_1_2(Object method) {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.successfulRequestWithParent(method)", (int)181, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "successfulRequestWithParent"))), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(2), method)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(5, false)), (boolean)false, (int)4);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.successfulRequestWithParent(method)", (int)181, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @DataProviderMetadata(line=184, dataVariables={"method"})
    public /* synthetic */ Object $spock_feature_1_2prov0() {
        return BODY_METHODS;
    }

    @DataProcessorMetadata(dataVariables={"method"})
    public /* synthetic */ Object $spock_feature_1_2proc(Object $spock_p0) {
        Object method = $spock_p0;
        return new Object[]{method};
    }

    @FeatureMetadata(line=187, name="basic GET request with not sampled parent", ordinal=3, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_3() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.successfulRequestWithNotSampledParent()", (int)189, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "successfulRequestWithNotSampledParent"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.successfulRequestWithNotSampledParent()", (int)189, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=192, name="should suppress nested CLIENT span if already under parent CLIENT span (#method)", ordinal=4, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={}), @BlockMetadata(kind=BlockKind.WHERE, texts={})}, parameterNames={"method"})
    public void $spock_feature_1_4(Object method) {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testWithClientParent", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.shouldSuppressNestedClientSpanIfAlreadyUnderParentClientSpan(method)", (int)195, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "shouldSuppressNestedClientSpanIfAlreadyUnderParentClientSpan"))), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(2), method)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(5, false)), (boolean)false, (int)4);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.shouldSuppressNestedClientSpanIfAlreadyUnderParentClientSpan(method)", (int)195, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @DataProviderMetadata(line=198, dataVariables={"method"})
    public /* synthetic */ Object $spock_feature_1_4prov0() {
        return BODY_METHODS;
    }

    @DataProcessorMetadata(dataVariables={"method"})
    public /* synthetic */ Object $spock_feature_1_4proc(Object $spock_p0) {
        Object method = $spock_p0;
        return new Object[]{method};
    }

    @FeatureMetadata(line=203, name="trace request with callback and parent", ordinal=5, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_5() {
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallback", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallbackWithParent", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            IndyInterface.bootstrap("invoke", "requestWithCallbackAndParent", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this));
        }
        catch (Exception ignored) {
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=213, name="trace request with callback and no parent", ordinal=6, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_6() {
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallback", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            IndyInterface.bootstrap("invoke", "requestWithCallbackAndNoParent", 0, IndyInterface.bootstrap("getProperty", "junitTest", 12, this));
        }
        catch (Exception ignored) {
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=222, name="basic request with 1 redirect", ordinal=7, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_7() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRedirects", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.basicRequestWith1Redirect()", (int)225, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "basicRequestWith1Redirect"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.basicRequestWith1Redirect()", (int)225, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=228, name="basic request with 2 redirects", ordinal=8, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_8() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRedirects", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.basicRequestWith2Redirects()", (int)231, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "basicRequestWith2Redirects"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.basicRequestWith2Redirects()", (int)231, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=234, name="basic request with circular redirects", ordinal=9, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_9() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRedirects", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCircularRedirects", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.circularRedirects()", (int)238, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "circularRedirects"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.circularRedirects()", (int)238, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=241, name="redirect to secured endpoint copies auth header", ordinal=10, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_10() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRedirects", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.redirectToSecuredCopiesAuthHeader()", (int)244, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "redirectToSecuredCopiesAuthHeader"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.redirectToSecuredCopiesAuthHeader()", (int)244, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=247, name="error span for #path", ordinal=11, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={}), @BlockMetadata(kind=BlockKind.WHERE, texts={})}, parameterNames={"path", "statusCode"})
    public void $spock_feature_1_11(Object path, Object statusCode) {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.errorSpan(path, statusCode)", (int)249, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "errorSpan"))), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(2), path), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(3), statusCode)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(6, false)), (boolean)false, (int)5);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.errorSpan(path, statusCode)", (int)249, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @DataProviderMetadata(line=-1, dataVariables={"path"}, previousDataTableVariables={})
    public /* synthetic */ Object $spock_feature_1_11prov0() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{"/client-error", "/error"});
    }

    @DataProviderMetadata(line=-1, dataVariables={"statusCode"}, previousDataTableVariables={"path"})
    public /* synthetic */ Object $spock_feature_1_11prov1(List $spock_p_path) {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 500});
    }

    @DataProcessorMetadata(dataVariables={"path", "statusCode"})
    public /* synthetic */ Object $spock_feature_1_11proc(Object $spock_p0, Object $spock_p1) {
        Object path = $spock_p0;
        Object statusCode = $spock_p1;
        return new Object[]{path, statusCode};
    }

    @FeatureMetadata(line=257, name="reuse request", ordinal=12, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_12() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testReusedRequest", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.reuseRequest()", (int)260, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "reuseRequest"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.reuseRequest()", (int)260, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=269, name="request with existing tracing headers", ordinal=13, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_13() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.requestWithExistingTracingHeaders()", (int)271, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "requestWithExistingTracingHeaders"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.requestWithExistingTracingHeaders()", (int)271, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=274, name="test captured HTTP headers", ordinal=14, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_14() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCapturedHttpHeaders", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.captureHttpHeaders()", (int)277, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "captureHttpHeaders"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.captureHttpHeaders()", (int)277, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=280, name="connection error (unopened port)", ordinal=15, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_15() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testConnectionFailure", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.connectionErrorUnopenedPort()", (int)283, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "connectionErrorUnopenedPort"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.connectionErrorUnopenedPort()", (int)283, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=286, name="connection error (unopened port) with callback", ordinal=16, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_16() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testConnectionFailure", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallback", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testErrorWithCallback", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.connectionErrorUnopenedPortWithCallback()", (int)291, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "connectionErrorUnopenedPortWithCallback"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.connectionErrorUnopenedPortWithCallback()", (int)291, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=294, name="connection error non routable address", ordinal=17, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_17() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRemoteConnection", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.connectionErrorNonRoutableAddress()", (int)297, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "connectionErrorNonRoutableAddress"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.connectionErrorNonRoutableAddress()", (int)297, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=300, name="read timed out", ordinal=18, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_18() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testReadTimeout", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.readTimedOut()", (int)303, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "readTimedOut"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.readTimedOut()", (int)303, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @Requires(value=__spock_feature_1_19_closure1.class)
    @FeatureMetadata(line=307, name="test https request", ordinal=19, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_19() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testRemoteConnection", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testHttps", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.httpsRequest()", (int)312, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "httpsRequest"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.httpsRequest()", (int)312, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=315, name="http client metrics", ordinal=20, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_20() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.httpClientMetrics()", (int)317, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "httpClientMetrics"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.httpClientMetrics()", (int)317, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=327, name="high concurrency test", ordinal=21, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_21() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.highConcurrency()", (int)329, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "highConcurrency"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.highConcurrency()", (int)329, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=332, name="high concurrency test with callback", ordinal=22, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_22() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallback", 2, this));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, IndyInterface.bootstrap("invoke", "testCallbackWithParent", 2, this));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.highConcurrencyWithCallback()", (int)336, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "highConcurrencyWithCallback"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.highConcurrencyWithCallback()", (int)336, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    @FeatureMetadata(line=343, name="high concurrency test on single connection", ordinal=23, blocks={@BlockMetadata(kind=BlockKind.EXPECT, texts={})}, parameterNames={})
    public void $spock_feature_1_23() {
        CallSite $spock_errorCollector = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, ErrorRethrower.class));
        CallSite $spock_valueRecorder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ValueRecorder.class));
        CallSite singleConnection = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createSingleConnection", 2, this, "localhost", IndyInterface.bootstrap("invoke", "httpPort", 0, IndyInterface.bootstrap("getProperty", "server", 12, this))));
        IndyInterface.bootstrap("invoke", "assumeTrue", 0, Assumptions.class, ScriptBytecodeAdapter.compareNotEqual((Object)singleConnection, null));
        SpockRuntime.callBlockEntered((Specification)this, (int)0);
        try {
            SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"junitTest.highConcurrencyOnSingleConnection()", (int)347, (int)5, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(0), IndyInterface.bootstrap("getProperty", "junitTest", 12, this)), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(1), "highConcurrencyOnSingleConnection"))), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(4, false)), (boolean)false, (int)3);
        }
        catch (Throwable $spock_condition_throwable) {
            SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"junitTest.highConcurrencyOnSingleConnection()", (int)347, (int)5, null, (Throwable)$spock_condition_throwable);
        }
        SpockRuntime.callBlockExited((Specification)this, (int)0);
        IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.getSpecificationContext()).getMockController()).leaveScope();
    }

    public /* synthetic */ Object this$dist$invoke$5(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HttpClientTest.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HttpClientTest.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(HttpClientTest.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$5(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, HttpClientTest.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$5(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(HttpClientTest.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    public final int doRequest(String method, URI uri) {
        return this.doRequest(method, uri, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public final void clientSpan(TraceAssert trace, int index, Object parentSpan, String method, URI uri) {
        this.clientSpan(trace, index, parentSpan, method, uri, 200);
    }

    @Generated
    public final void clientSpan(TraceAssert trace, int index, Object parentSpan, String method) {
        this.clientSpan(trace, index, parentSpan, method, (URI)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveAddress", 2, this, "/success"))), 200);
    }

    @Generated
    public final void clientSpan(TraceAssert trace, int index, Object parentSpan) {
        this.clientSpan(trace, index, parentSpan, "GET", (URI)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveAddress", 2, this, "/success"))), 200);
    }

    @Generated
    public final void serverSpan(TraceAssert trace, int index) {
        this.serverSpan(trace, index, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != HttpClientTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        int n = 2000;
        READ_TIMEOUT_MS = n;
        int n2 = 5000;
        CONNECT_TIMEOUT_MS = n2;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"POST", "PUT"});
        BODY_METHODS = list;
    }

    @Generated
    public Object get$spock_sharedField_junitTest() {
        return this.$spock_sharedField_junitTest;
    }

    @Generated
    public void set$spock_sharedField_junitTest(Object object) {
        this.$spock_sharedField_junitTest = object;
    }

    @Generated
    public HttpClientTestServer get$spock_sharedField_server() {
        return this.$spock_sharedField_server;
    }

    @Generated
    public void set$spock_sharedField_server(HttpClientTestServer httpClientTestServer) {
        this.$spock_sharedField_server = httpClientTestServer;
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public class 1
    extends AbstractHttpClientTest
    implements GroovyObject {
        final /* synthetic */ HttpClientTest this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1(HttpClientTest p0) {
            MetaClass metaClass;
            HttpClientTest httpClientTest;
            this.this$0 = httpClientTest = p0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public Object buildRequest(String method, URI uri, Map<String, String> headers) {
            return IndyInterface.bootstrap("invoke", "buildRequest", 0, this.this$0, method, uri, headers);
        }

        @Override
        public int sendRequest(Object request, String method, URI uri, Map<String, String> headers) {
            return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "sendRequest", 0, this.this$0, request, method, uri, headers));
        }

        @Override
        public void sendRequestWithCallback(Object request, String method, URI uri, Map<String, String> headers, HttpClientResult requestResult) {
            IndyInterface.bootstrap("invoke", "sendRequestWithCallback", 0, this.this$0, request, method, uri, headers, requestResult);
        }

        @Override
        protected void configure(HttpClientTestOptions.Builder optionsBuilder) {
            IndyInterface.bootstrap("invoke", "setHttpAttributes", 0, optionsBuilder, ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this.this$0), (String)"httpAttributes"));
            IndyInterface.bootstrap("invoke", "setResponseCodeOnRedirectError", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "responseCodeOnRedirectError", 2, this));
            IndyInterface.bootstrap("invoke", "setClientSpanErrorMapper", 0, optionsBuilder, ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this.this$0), (String)"clientSpanError"));
            IndyInterface.bootstrap("invoke", "setSingleConnectionFactory", 0, optionsBuilder, ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this.this$0), (String)"createSingleConnection"));
            IndyInterface.bootstrap("invoke", "setExpectedClientSpanNameMapper", 0, optionsBuilder, ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this.this$0), (String)"expectedClientSpanName"));
            IndyInterface.bootstrap("invoke", "setTestWithClientParent", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testWithClientParent", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestRedirects", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testRedirects", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestCircularRedirects", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testCircularRedirects", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setMaxRedirects", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "maxRedirects", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestReusedRequest", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testReusedRequest", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestConnectionFailure", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testConnectionFailure", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestReadTimeout", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testReadTimeout", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestRemoteConnection", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testRemoteConnection", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestHttps", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testHttps", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestCallback", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testCallback", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestCallbackWithParent", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testCallbackWithParent", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestErrorWithCallback", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testErrorWithCallback", 0, this.this$0));
            IndyInterface.bootstrap("invoke", "setTestNonStandardHttpMethod", 0, optionsBuilder, IndyInterface.bootstrap("invoke", "testNonStandardHttpMethod", 0, this.this$0));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            try {
                return this.this$0.this$dist$invoke$5(name, args);
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, HttpClientTest.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, HttpClientTest.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, HttpClientTest.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                this.this$0.this$dist$set$5(name, value);
                return;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, HttpClientTest.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            try {
                return this.this$0.this$dist$get$5(name);
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, HttpClientTest.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        public /* synthetic */ void super$1$sendRequestWithCallback(Object object, String string, URI uRI, Map map, HttpClientResult httpClientResult) {
            super.sendRequestWithCallback(object, string, uRI, map, httpClientResult);
        }

        public /* synthetic */ void super$2$configure(HttpClientTestOptions.Builder builder) {
            super.configure(builder);
        }
    }
}

