/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.asserts;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import io.opentelemetry.instrumentation.test.asserts.SpanAssert;
import io.opentelemetry.instrumentation.testing.util.TelemetryDataUtil;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class TraceAssert
implements GroovyObject {
    private final List<SpanData> spans;
    private final Set<Integer> assertedIndexes;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private TraceAssert(Object spans) {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
        this.assertedIndexes = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = spans;
        this.spans = IndyInterface.bootstrap("cast", "()", 0, object);
    }

    public static void assertTrace(Supplier<List<SpanData>> spanSupplier, String traceId, int expectedSize, @ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.TraceAssert"}) @DelegatesTo(strategy=1, value=TraceAssert.class) Closure spec) {
        CallSite spans = IndyInterface.bootstrap("invoke", "getTrace", 0, TraceAssert.class, spanSupplier, traceId);
        CallSite startTime = IndyInterface.bootstrap("invoke", "nanoTime", 0, System.class);
        while (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, spans), (Object)expectedSize) && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "elapsedSeconds", 0, TraceAssert.class, startTime), (Object)10)) {
            IndyInterface.bootstrap("invoke", "sleep", 0, Thread.class, 10);
            IndyInterface.bootstrap("invoke", "getTrace", 0, TraceAssert.class, spanSupplier, traceId);
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = spans;
            valueRecorder.record((Object)callSite, 8);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "size", 0, callSite);
            valueRecorder.record((Object)callSite2, 14);
            int n = expectedSize;
            valueRecorder.record((Object)n, 24);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite2, (Object)n);
            valueRecorder.record((Object)bl, 21);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert spans.size() == expectedSize", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite asserter = IndyInterface.bootstrap("init", "<init>", 0, TraceAssert.class, spans);
        CallSite clone = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, spec));
        CallSite callSite = asserter;
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)clone, (String)"delegate");
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "DELEGATE_FIRST", 0, Closure.class);
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)clone, (String)"resolveStrategy");
        IndyInterface.bootstrap("invoke", "call", 0, clone, asserter);
        IndyInterface.bootstrap("invoke", "assertSpansAllVerified", 0, asserter);
    }

    private static long elapsedSeconds(long startTime) {
        return DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "toSeconds", 0, IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "nanoTime", 0, System.class), startTime)));
    }

    public List<SpanData> getSpans() {
        return this.spans;
    }

    public SpanData span(int index) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.spans, index));
    }

    public void span(int index, @ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.SpanAssert"}) @DelegatesTo(strategy=1, value=SpanAssert.class) Closure spec) {
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)index, (Object)IndyInterface.bootstrap("invoke", "size", 0, this.spans))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, ArrayIndexOutOfBoundsException.class, index));
        }
        IndyInterface.bootstrap("invoke", "add", 0, this.assertedIndexes, index);
        IndyInterface.bootstrap("invoke", "assertSpan", 0, SpanAssert.class, IndyInterface.bootstrap("invoke", "get", 0, this.spans, index), spec);
    }

    public void span(String name, @ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.SpanAssert"}) @DelegatesTo(strategy=1, value=SpanAssert.class) Closure spec) {
        int index = -1;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "size", 0, this.spans))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.spans, i)), (Object)name)) {
                index = i;
                break;
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        IndyInterface.bootstrap("invoke", "span", 2, this, index, spec);
    }

    public void assertSpansAllVerified() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Set<Integer> set = this.assertedIndexes;
            valueRecorder.record(set, 8);
            valueRecorder.record(set, 8);
            CallSite callSite = IndyInterface.bootstrap("invoke", "size", 0, set);
            valueRecorder.record((Object)callSite, 24);
            List<SpanData> list = this.spans;
            valueRecorder.record(list, 34);
            valueRecorder.record(list, 34);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "size", 0, list);
            valueRecorder.record((Object)callSite2, 40);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)callSite2);
            valueRecorder.record((Object)bl, 31);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert assertedIndexes.size() == spans.size()", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    private static List<SpanData> getTrace(Supplier<List<SpanData>> spanSupplier, String traceId) {
        CallSite traces = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupTraces", 0, TelemetryDataUtil.class, IndyInterface.bootstrap("invoke", "get", 0, spanSupplier)));
        CallSite trace = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, traces));
        if (callSite != null) {
            while (callSite.hasNext()) {
                trace = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "traceId", 0, IndyInterface.bootstrap("invoke", "getAt", 0, trace, false)), (Object)traceId)) continue;
                return trace;
            }
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AssertionError.class, IndyInterface.bootstrap("invoke", "plus", 0, "Trace not found: ", traceId)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TraceAssert.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

