/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SortedConcurrentMappingSet;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import io.opentelemetry.testing.internal.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.guava.base.Optional;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.guava.collect.FluentIterable;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.guava.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InMemoryStubMappings
implements StubMappings {
    private final SortedConcurrentMappingSet mappings = new SortedConcurrentMappingSet();
    private final Scenarios scenarios;
    private final Map<String, RequestMatcherExtension> customMatchers;
    private final Map<String, ResponseDefinitionTransformer> transformers;
    private final FileSource rootFileSource;
    private final List<StubLifecycleListener> stubLifecycleListeners;

    public InMemoryStubMappings(Scenarios scenarios, Map<String, RequestMatcherExtension> customMatchers, Map<String, ResponseDefinitionTransformer> transformers, FileSource rootFileSource, List<StubLifecycleListener> stubLifecycleListeners) {
        this.scenarios = scenarios;
        this.customMatchers = customMatchers;
        this.transformers = transformers;
        this.rootFileSource = rootFileSource;
        this.stubLifecycleListeners = stubLifecycleListeners;
    }

    public InMemoryStubMappings() {
        this(new Scenarios(), Collections.emptyMap(), Collections.emptyMap(), new SingleRootFileSource("."), Collections.emptyList());
    }

    @Override
    public ServeEvent serveFor(Request request) {
        StubMapping matchingMapping = Iterables.find(this.mappings, this.mappingMatchingAndInCorrectScenarioState(request), StubMapping.NOT_CONFIGURED);
        this.scenarios.onStubServed(matchingMapping);
        ResponseDefinition responseDefinition = this.applyTransformations(request, matchingMapping.getResponse(), ImmutableList.copyOf(this.transformers.values()));
        return ServeEvent.of(LoggedRequest.createFrom(request), ResponseDefinition.copyOf(responseDefinition), matchingMapping);
    }

    private ResponseDefinition applyTransformations(Request request, ResponseDefinition responseDefinition, List<ResponseDefinitionTransformer> transformers) {
        if (transformers.isEmpty()) {
            return responseDefinition;
        }
        ResponseDefinitionTransformer transformer = transformers.get(0);
        ResponseDefinition newResponseDef = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request, responseDefinition, this.rootFileSource.child("__files"), MoreObjects.firstNonNull(responseDefinition.getTransformerParameters(), Parameters.empty())) : responseDefinition;
        return this.applyTransformations(request, newResponseDef, transformers.subList(1, transformers.size()));
    }

    @Override
    public void addMapping(StubMapping mapping) {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubCreated(mapping);
        }
        this.mappings.add(mapping);
        this.scenarios.onStubMappingAdded(mapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubCreated(mapping);
        }
    }

    @Override
    public void removeMapping(StubMapping mapping) {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubRemoved(mapping);
        }
        this.mappings.remove(mapping);
        this.scenarios.onStubMappingRemoved(mapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubRemoved(mapping);
        }
    }

    @Override
    public void editMapping(StubMapping stubMapping) {
        Optional<StubMapping> optionalExistingMapping = Iterables.tryFind(this.mappings, this.mappingMatchingUuid(stubMapping.getUuid()));
        if (!optionalExistingMapping.isPresent()) {
            String msg = "StubMapping with UUID: " + stubMapping.getUuid() + " not found";
            LocalNotifier.notifier().error(msg);
            throw new RuntimeException(msg);
        }
        StubMapping existingMapping = optionalExistingMapping.get();
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubEdited(existingMapping, stubMapping);
        }
        stubMapping.setInsertionIndex(existingMapping.getInsertionIndex());
        stubMapping.setDirty(true);
        this.mappings.replace(existingMapping, stubMapping);
        this.scenarios.onStubMappingUpdated(existingMapping, stubMapping);
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubEdited(existingMapping, stubMapping);
        }
    }

    @Override
    public void reset() {
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.beforeStubsReset();
        }
        this.mappings.clear();
        this.scenarios.clear();
        for (StubLifecycleListener listener : this.stubLifecycleListeners) {
            listener.afterStubsReset();
        }
    }

    @Override
    public void resetScenarios() {
        this.scenarios.reset();
    }

    @Override
    public List<StubMapping> getAll() {
        return ImmutableList.copyOf(this.mappings);
    }

    @Override
    public Optional<StubMapping> get(final UUID id) {
        return Iterables.tryFind(this.mappings, new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input.getUuid().equals(id);
            }
        });
    }

    @Override
    public List<Scenario> getAllScenarios() {
        return this.scenarios.getAll();
    }

    @Override
    public List<StubMapping> findByMetadata(final StringValuePattern pattern) {
        return FluentIterable.from(this.mappings).filter(new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping stub) {
                String metadataJson = Json.write(stub.getMetadata());
                return pattern.match(metadataJson).isExactMatch();
            }
        }).toList();
    }

    private Predicate<StubMapping> mappingMatchingAndInCorrectScenarioState(Request request) {
        return this.mappingMatchingAndInCorrectScenarioStateNew(request);
    }

    private Predicate<StubMapping> mappingMatchingAndInCorrectScenarioStateNew(final Request request) {
        return new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping mapping) {
                return mapping.getRequest().match(request, InMemoryStubMappings.this.customMatchers).isExactMatch() && (mapping.isIndependentOfScenarioState() || InMemoryStubMappings.this.scenarios.mappingMatchesScenarioState(mapping));
            }
        };
    }

    private Predicate<StubMapping> mappingMatchingUuid(final UUID uuid) {
        return new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input.getUuid().equals(uuid);
            }
        };
    }
}

