/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import io.opentelemetry.testing.internal.guava.base.Charsets;
import io.opentelemetry.testing.internal.jetty.io.ChannelEndPoint;
import io.opentelemetry.testing.internal.jetty.server.HttpChannel;
import io.opentelemetry.testing.internal.jetty.server.Response;
import io.opentelemetry.testing.internal.jetty.util.BufferUtil;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.Socket;

public class JettyFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(Charsets.UTF_8);
    private final Response response;
    private final Socket socket;

    public JettyFaultInjector(HttpServletResponse response) {
        this.response = JettyUtils.unwrapResponse(response);
        this.socket = this.socket();
    }

    @Override
    public void connectionResetByPeer() {
        try {
            this.socket.setSoLinger(true, 0);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.socket.getChannel().write(BufferUtil.toBuffer(GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void randomDataAndCloseConnection() {
        try {
            this.socket.getChannel().write(BufferUtil.toBuffer(GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private Socket socket() {
        HttpChannel httpChannel = this.response.getHttpOutput().getHttpChannel();
        ChannelEndPoint ep = (ChannelEndPoint)httpChannel.getEndPoint();
        return ep.getChannel().socket();
    }
}

