/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.Joiner;
import io.opentelemetry.testing.internal.guava.collect.Lists;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class JsonException
extends InvalidInputException {
    private static final Function<JsonMappingException.Reference, String> TO_NODE_NAMES = new Function<JsonMappingException.Reference, String>(){

        @Override
        public String apply(JsonMappingException.Reference input) {
            if (input.getFieldName() != null) {
                return input.getFieldName();
            }
            return String.valueOf(input.getIndex());
        }
    };

    protected JsonException(Errors errors) {
        super(errors);
    }

    public static JsonException fromJackson(JsonProcessingException processingException) {
        Throwable rootCause = JsonException.getRootCause(processingException);
        String message = rootCause.getMessage();
        if (rootCause instanceof PatternSyntaxException) {
            PatternSyntaxException patternSyntaxException = (PatternSyntaxException)rootCause;
            message = patternSyntaxException.getMessage();
        } else if (rootCause instanceof JsonMappingException) {
            message = ((JsonMappingException)rootCause).getOriginalMessage();
        } else if (rootCause instanceof InvalidInputException) {
            message = ((InvalidInputException)rootCause).getErrors().first().getDetail();
        }
        String pointer = null;
        if (processingException instanceof JsonMappingException) {
            List<String> nodes = Lists.transform(((JsonMappingException)processingException).getPath(), TO_NODE_NAMES);
            pointer = '/' + Joiner.on('/').join(nodes);
        }
        return new JsonException(Errors.single(10, pointer, "Error parsing JSON", message));
    }

    private static Throwable getRootCause(Throwable e) {
        if (e.getCause() != null) {
            return JsonException.getRootCause(e.getCause());
        }
        return e;
    }
}

