/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ArrayBackedExtendedAttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public interface ExtendedAttributesBuilder {
    public ExtendedAttributes build();

    default public <T> ExtendedAttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        return this.put(ExtendedAttributeKey.fromAttributeKey(key), value);
    }

    public <T> ExtendedAttributesBuilder put(ExtendedAttributeKey<T> var1, T var2);

    default public ExtendedAttributesBuilder put(String key, String value) {
        return this.put(ExtendedAttributeKey.stringKey(key), value);
    }

    default public ExtendedAttributesBuilder put(String key, long value) {
        return this.put(ExtendedAttributeKey.longKey(key), Long.valueOf(value));
    }

    default public ExtendedAttributesBuilder put(String key, double value) {
        return this.put(ExtendedAttributeKey.doubleKey(key), Double.valueOf(value));
    }

    default public ExtendedAttributesBuilder put(String key, boolean value) {
        return this.put(ExtendedAttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    @Deprecated
    default public <T> ExtendedAttributesBuilder put(String key, ExtendedAttributes value) {
        return this.put(ExtendedAttributeKey.extendedAttributesKey(key), value);
    }

    default public ExtendedAttributesBuilder put(String key, String ... value) {
        if (value == null) {
            return this;
        }
        return this.put(ExtendedAttributeKey.stringArrayKey(key), Arrays.asList(value));
    }

    default public <T> ExtendedAttributesBuilder put(AttributeKey<List<T>> key, T ... value) {
        if (value == null) {
            return this;
        }
        return this.put((AttributeKey<T>)key, (T)Arrays.asList(value));
    }

    default public ExtendedAttributesBuilder put(String key, long ... value) {
        if (value == null) {
            return this;
        }
        return this.put(ExtendedAttributeKey.longArrayKey(key), ArrayBackedExtendedAttributesBuilder.toList(value));
    }

    default public ExtendedAttributesBuilder put(String key, double ... value) {
        if (value == null) {
            return this;
        }
        return this.put(ExtendedAttributeKey.doubleArrayKey(key), ArrayBackedExtendedAttributesBuilder.toList(value));
    }

    default public ExtendedAttributesBuilder put(String key, boolean ... value) {
        if (value == null) {
            return this;
        }
        return this.put(ExtendedAttributeKey.booleanArrayKey(key), ArrayBackedExtendedAttributesBuilder.toList(value));
    }

    default public ExtendedAttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((AttributeKey<T>)((AttributeKey)key), (T)value));
        return this;
    }

    default public ExtendedAttributesBuilder putAll(ExtendedAttributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((ExtendedAttributeKey)key, (Object)value));
        return this;
    }

    default public <T> ExtendedAttributesBuilder remove(AttributeKey<T> key) {
        return this.remove(ExtendedAttributeKey.fromAttributeKey(key));
    }

    default public <T> ExtendedAttributesBuilder remove(ExtendedAttributeKey<T> key) {
        if (key == null || key.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(entryKey -> key.getKey().equals(entryKey.getKey()) && key.getType().equals((Object)entryKey.getType()));
    }

    public ExtendedAttributesBuilder removeIf(Predicate<ExtendedAttributeKey<?>> var1);
}

