/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import java.util.Objects;

public class EnduserConfig {
    private final boolean idEnabled;
    private final boolean roleEnabled;
    private final boolean scopeEnabled;

    EnduserConfig(DeclarativeConfigProperties commonConfig) {
        Objects.requireNonNull(commonConfig, "commonConfig must not be null");
        this.idEnabled = commonConfig.get("enduser").get("id").getBoolean("enabled", false);
        this.roleEnabled = commonConfig.get("enduser").get("role").getBoolean("enabled", false);
        this.scopeEnabled = commonConfig.get("enduser").get("scope").getBoolean("enabled", false);
    }

    public boolean isAnyEnabled() {
        return this.idEnabled || this.roleEnabled || this.scopeEnabled;
    }

    public boolean isIdEnabled() {
        return this.idEnabled;
    }

    public boolean isRoleEnabled() {
        return this.roleEnabled;
    }

    public boolean isScopeEnabled() {
        return this.scopeEnabled;
    }
}

