/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.DeclarativeConfigUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.EnduserConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class CommonConfig {
    private final PeerServiceResolver peerServiceResolver;
    private final List<String> clientRequestHeaders;
    private final List<String> clientResponseHeaders;
    private final List<String> serverRequestHeaders;
    private final List<String> serverResponseHeaders;
    private final Set<String> knownHttpRequestMethods;
    private final EnduserConfig enduserConfig;
    private final boolean statementSanitizationEnabled;
    private final boolean sqlCommenterEnabled;
    private final boolean emitExperimentalHttpClientTelemetry;
    private final boolean emitExperimentalHttpServerTelemetry;
    private final boolean redactQueryParameters;
    private final String loggingTraceIdKey;
    private final String loggingSpanIdKey;
    private final String loggingTraceFlagsKey;

    public CommonConfig(OpenTelemetry openTelemetry) {
        DeclarativeConfigProperties generalConfig = DeclarativeConfigUtil.getGeneralInstrumentationConfig(openTelemetry);
        DeclarativeConfigProperties commonConfig = DeclarativeConfigUtil.getInstrumentationConfig(openTelemetry, "common");
        this.peerServiceResolver = PeerServiceResolver.create(openTelemetry);
        this.clientRequestHeaders = generalConfig.get("http").get("client").getScalarList("request_captured_headers", String.class, new ArrayList());
        this.clientResponseHeaders = generalConfig.get("http").get("client").getScalarList("response_captured_headers", String.class, new ArrayList());
        this.serverRequestHeaders = generalConfig.get("http").get("server").getScalarList("request_captured_headers", String.class, new ArrayList());
        this.serverResponseHeaders = generalConfig.get("http").get("server").getScalarList("response_captured_headers", String.class, new ArrayList());
        this.knownHttpRequestMethods = new HashSet<String>(commonConfig.get("http").getScalarList("known_methods", String.class, new ArrayList<String>(HttpConstants.KNOWN_METHODS)));
        this.statementSanitizationEnabled = commonConfig.get("database").get("statement_sanitizer").getBoolean("enabled", true);
        this.sqlCommenterEnabled = commonConfig.get("database").get("sqlcommenter/development").getBoolean("enabled", false);
        this.emitExperimentalHttpClientTelemetry = commonConfig.get("http").get("client").getBoolean("emit_experimental_telemetry/development", false);
        this.redactQueryParameters = commonConfig.get("http").get("client").getBoolean("redact_query_parameters/development", true);
        this.emitExperimentalHttpServerTelemetry = commonConfig.get("http").get("server").getBoolean("emit_experimental_telemetry/development", false);
        this.enduserConfig = new EnduserConfig(commonConfig);
        this.loggingTraceIdKey = commonConfig.get("logging").getString("trace_id", "trace_id");
        this.loggingSpanIdKey = commonConfig.get("logging").getString("span_id", "span_id");
        this.loggingTraceFlagsKey = commonConfig.get("logging").getString("trace_flags", "trace_flags");
    }

    public PeerServiceResolver getPeerServiceResolver() {
        return this.peerServiceResolver;
    }

    public List<String> getClientRequestHeaders() {
        return this.clientRequestHeaders;
    }

    public List<String> getClientResponseHeaders() {
        return this.clientResponseHeaders;
    }

    public List<String> getServerRequestHeaders() {
        return this.serverRequestHeaders;
    }

    public List<String> getServerResponseHeaders() {
        return this.serverResponseHeaders;
    }

    public Set<String> getKnownHttpRequestMethods() {
        return this.knownHttpRequestMethods;
    }

    public EnduserConfig getEnduserConfig() {
        return this.enduserConfig;
    }

    public boolean isStatementSanitizationEnabled() {
        return this.statementSanitizationEnabled;
    }

    public boolean isSqlCommenterEnabled() {
        return this.sqlCommenterEnabled;
    }

    public boolean shouldEmitExperimentalHttpClientTelemetry() {
        return this.emitExperimentalHttpClientTelemetry;
    }

    public boolean shouldEmitExperimentalHttpServerTelemetry() {
        return this.emitExperimentalHttpServerTelemetry;
    }

    public boolean redactQueryParameters() {
        return this.redactQueryParameters;
    }

    public String getTraceIdKey() {
        return this.loggingTraceIdKey;
    }

    public String getSpanIdKey() {
        return this.loggingSpanIdKey;
    }

    public String getTraceFlagsKey() {
        return this.loggingTraceFlagsKey;
    }

    static interface ValueProvider<T> {
        @Nullable
        public T get(ConfigProvider var1);
    }
}

