/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.servlet;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ServletContextPath {
    private static final ContextKey<ServletContextPath> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-context-path-key");
    @Nullable
    private final String contextPath;

    public static <REQUEST> Context init(Context context, Function<REQUEST, String> contextPathExtractor, REQUEST request) {
        ServletContextPath servletContextPath = context.get(CONTEXT_KEY);
        if (servletContextPath != null) {
            return context;
        }
        String contextPath = contextPathExtractor.apply(request);
        if (contextPath == null) {
            return context;
        }
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            contextPath = null;
        }
        return context.with(CONTEXT_KEY, new ServletContextPath(contextPath));
    }

    private ServletContextPath(@Nullable String contextPath) {
        this.contextPath = contextPath;
    }

    @Nullable
    public static String prepend(Context context, @Nullable String spanName) {
        String value;
        ServletContextPath servletContextPath = context.get(CONTEXT_KEY);
        if (servletContextPath != null && (value = servletContextPath.contextPath) != null) {
            if (spanName == null || spanName.isEmpty()) {
                return value;
            }
            return value + (spanName.startsWith("/") ? spanName : "/" + spanName);
        }
        return spanName;
    }
}

