/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class ConfigValueParsers {
    static List<String> parseList(String value) {
        String[] tokens = value.split(",", -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    static Map<String, String> parseMap(String value) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String token : value.split(",", -1)) {
            String[] parts = (token = token.trim()).split("=", -1);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid map config part, should be formatted key1=value1,key2=value2: " + value);
            }
            result.put(parts[0], parts[1]);
        }
        return Collections.unmodifiableMap(result);
    }

    static Duration parseDuration(String value) {
        String unitString = ConfigValueParsers.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        long rawNumber = Long.parseLong(numberString.trim());
        TimeUnit unit = ConfigValueParsers.getDurationUnit(unitString.trim());
        return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
    }

    private static TimeUnit getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Invalid duration string, found: " + unitString);
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }

    private ConfigValueParsers() {
    }
}

