/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.AutoValue_Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigValueParsers;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.NamingConvention;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static volatile @Nullable Config instance = null;

    public static ConfigBuilder newBuilder() {
        return new ConfigBuilder();
    }

    static Config create(Map<String, String> allProperties) {
        return new AutoValue_Config(allProperties);
    }

    Config() {
    }

    public static void internalInitializeConfig(Config config) {
        if (instance != null) {
            logger.warn("Config#INSTANCE was already set earlier");
            return;
        }
        instance = Objects.requireNonNull(config);
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.newBuilder().readEnvironmentVariables().readSystemProperties().build();
        }
        return instance;
    }

    public abstract Map<String, String> getAllProperties();

    @Deprecated
    public @Nullable String getProperty(String name) {
        return this.getRawProperty(name, null);
    }

    @Deprecated
    public String getProperty(String name, String defaultValue) {
        return this.getRawProperty(name, defaultValue);
    }

    public @Nullable String getString(String name) {
        return this.getRawProperty(name, null);
    }

    public String getString(String name, String defaultValue) {
        return this.getRawProperty(name, defaultValue);
    }

    public @Nullable Boolean getBoolean(String name) {
        return this.getTypedProperty(name, Boolean::parseBoolean, null);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getTypedProperty(name, Boolean::parseBoolean, defaultValue);
    }

    @Deprecated
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getTypedProperty(name, Boolean::parseBoolean, defaultValue);
    }

    public @Nullable Integer getInt(String name) {
        return this.getTypedProperty(name, Integer::parseInt, null);
    }

    public int getInt(String name, int defaultValue) {
        return this.getTypedProperty(name, Integer::parseInt, defaultValue);
    }

    public @Nullable Long getLong(String name) {
        return this.getTypedProperty(name, Long::parseLong, null);
    }

    public long getLong(String name, long defaultValue) {
        return this.getTypedProperty(name, Long::parseLong, defaultValue);
    }

    public @Nullable Double getDouble(String name) {
        return this.getTypedProperty(name, Double::parseDouble, null);
    }

    public double getDouble(String name, double defaultValue) {
        return this.getTypedProperty(name, Double::parseDouble, defaultValue);
    }

    public @Nullable Duration getDuration(String name) {
        return this.getTypedProperty(name, ConfigValueParsers::parseDuration, null);
    }

    public Duration getDuration(String name, Duration defaultValue) {
        return this.getTypedProperty(name, ConfigValueParsers::parseDuration, defaultValue);
    }

    @Deprecated
    public List<String> getListProperty(String name) {
        return this.getListProperty(name, Collections.emptyList());
    }

    @Deprecated
    public List<String> getListProperty(String name, List<String> defaultValue) {
        return this.getTypedProperty(name, ConfigValueParsers::parseList, defaultValue);
    }

    public List<String> getList(String name) {
        return this.getListProperty(name, Collections.emptyList());
    }

    public List<String> getList(String name, List<String> defaultValue) {
        return this.getTypedProperty(name, ConfigValueParsers::parseList, defaultValue);
    }

    @Deprecated
    public Map<String, String> getMapProperty(String name) {
        return this.getMap(name, Collections.emptyMap());
    }

    public Map<String, String> getMap(String name) {
        return this.getMap(name, Collections.emptyMap());
    }

    public Map<String, String> getMap(String name, Map<String, String> defaultValue) {
        return this.getTypedProperty(name, ConfigValueParsers::parseMap, defaultValue);
    }

    private <T> T getTypedProperty(String name, Function<String, T> parser, T defaultValue) {
        String value = this.getRawProperty(name, null);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return parser.apply(value);
        }
        catch (RuntimeException t) {
            logger.debug("Cannot parse {}", (Object)value, (Object)t);
            return defaultValue;
        }
    }

    private String getRawProperty(String name, String defaultValue) {
        return this.getAllProperties().getOrDefault(NamingConvention.DOT.normalize(name), defaultValue);
    }

    public boolean isInstrumentationEnabled(Iterable<String> instrumentationNames, boolean defaultEnabled) {
        return this.isInstrumentationPropertyEnabled(instrumentationNames, "enabled", defaultEnabled);
    }

    public boolean isInstrumentationPropertyEnabled(Iterable<String> instrumentationNames, String suffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : instrumentationNames) {
            String propertyName = "otel.instrumentation." + name + '.' + suffix;
            boolean enabled = this.getBooleanProperty(propertyName, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= enabled;
                continue;
            }
            anyEnabled |= enabled;
        }
        return anyEnabled;
    }

    public boolean isAgentDebugEnabled() {
        return this.getBooleanProperty("otel.javaagent.debug", false);
    }

    @Deprecated
    public Properties asJavaProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getAllProperties());
        return properties;
    }
}

