/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.AutoValue_PeerServiceResolverImpl_ServiceMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.PeerServiceResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.UrlParser;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class PeerServiceResolverImpl
implements PeerServiceResolver {
    private static final Comparator<ServiceMatcher> matcherComparator = Comparator.nullsFirst(Comparator.comparing(ServiceMatcher::getPort, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Comparator.comparing(ServiceMatcher::getPath, Comparator.nullsFirst(Comparator.naturalOrder()))));
    private final Map<String, Map<ServiceMatcher, String>> mapping = new HashMap<String, Map<ServiceMatcher, String>>();

    PeerServiceResolverImpl(Map<String, String> peerServiceMapping) {
        peerServiceMapping.forEach((key, serviceName) -> {
            String url = "https://" + key;
            String host = UrlParser.getHost(url);
            Integer port = UrlParser.getPort(url);
            String path = UrlParser.getPath(url);
            Map matchers = this.mapping.computeIfAbsent(host, x -> new HashMap());
            matchers.putIfAbsent(ServiceMatcher.create(port, path), serviceName);
        });
    }

    @Override
    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    @Override
    @Nullable
    public String resolveService(String host, @Nullable Integer port, @Nullable Supplier<String> pathSupplier) {
        Map<ServiceMatcher, String> matchers = this.mapping.get(host);
        if (matchers == null) {
            return null;
        }
        return matchers.entrySet().stream().filter(entry -> ((ServiceMatcher)entry.getKey()).matches(port, pathSupplier)).max((o1, o2) -> matcherComparator.compare((ServiceMatcher)o1.getKey(), (ServiceMatcher)o2.getKey())).map(Map.Entry::getValue).orElse(null);
    }

    @AutoValue
    static abstract class ServiceMatcher {
        ServiceMatcher() {
        }

        static ServiceMatcher create(Integer port, String path) {
            return new AutoValue_PeerServiceResolverImpl_ServiceMatcher(port, path);
        }

        @Nullable
        abstract Integer getPort();

        @Nullable
        abstract String getPath();

        public boolean matches(Integer port, Supplier<String> pathSupplier) {
            if (this.getPort() != null && !this.getPort().equals(port)) {
                return false;
            }
            if (this.getPath() != null && this.getPath().length() > 0) {
                if (pathSupplier == null) {
                    return false;
                }
                String path = pathSupplier.get();
                if (path == null) {
                    return false;
                }
                if (!path.startsWith(this.getPath())) {
                    return false;
                }
                if (port != null) {
                    return port.equals(this.getPort());
                }
            }
            return true;
        }
    }
}

