/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.internal.HttpAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.extension.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.extension.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.SemanticAttributes;
import java.util.Arrays;

final class HttpMetricsAdvice {
    static void applyStableClientDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, HttpAttributes.ERROR_TYPE, SemanticAttributes.NETWORK_PROTOCOL_NAME, SemanticAttributes.NETWORK_PROTOCOL_VERSION, SemanticAttributes.SERVER_ADDRESS, SemanticAttributes.SERVER_PORT, SemanticAttributes.URL_SCHEME));
    }

    static void applyOldClientDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_STATUS_CODE, SemanticAttributes.NET_PEER_NAME, SemanticAttributes.NET_PEER_PORT, SemanticAttributes.NET_PROTOCOL_NAME, SemanticAttributes.NET_PROTOCOL_VERSION, SemanticAttributes.NET_SOCK_PEER_ADDR));
    }

    static void applyClientRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, HttpAttributes.ERROR_TYPE, SemanticAttributes.NETWORK_PROTOCOL_NAME, SemanticAttributes.NETWORK_PROTOCOL_VERSION, SemanticAttributes.SERVER_ADDRESS, SemanticAttributes.SERVER_PORT, SemanticAttributes.URL_SCHEME, SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_STATUS_CODE, SemanticAttributes.NET_PEER_NAME, SemanticAttributes.NET_PEER_PORT, SemanticAttributes.NET_PROTOCOL_NAME, SemanticAttributes.NET_PROTOCOL_VERSION, SemanticAttributes.NET_SOCK_PEER_ADDR));
    }

    static void applyStableServerDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_ROUTE, SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, HttpAttributes.ERROR_TYPE, SemanticAttributes.NETWORK_PROTOCOL_NAME, SemanticAttributes.NETWORK_PROTOCOL_VERSION, SemanticAttributes.URL_SCHEME));
    }

    static void applyOldServerDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_SCHEME, SemanticAttributes.HTTP_ROUTE, SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_STATUS_CODE, SemanticAttributes.NET_HOST_NAME, SemanticAttributes.NET_HOST_PORT, SemanticAttributes.NET_PROTOCOL_NAME, SemanticAttributes.NET_PROTOCOL_VERSION));
    }

    static void applyServerRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_ROUTE, SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, HttpAttributes.ERROR_TYPE, SemanticAttributes.NETWORK_PROTOCOL_NAME, SemanticAttributes.NETWORK_PROTOCOL_VERSION, SemanticAttributes.URL_SCHEME, SemanticAttributes.HTTP_SCHEME, SemanticAttributes.HTTP_ROUTE, SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_STATUS_CODE, SemanticAttributes.NET_HOST_NAME, SemanticAttributes.NET_HOST_PORT, SemanticAttributes.NET_PROTOCOL_NAME, SemanticAttributes.NET_PROTOCOL_VERSION));
    }

    static void applyServerActiveRequestsAdvice(LongUpDownCounterBuilder builder) {
        if (!(builder instanceof ExtendedLongUpDownCounterBuilder)) {
            return;
        }
        ((ExtendedLongUpDownCounterBuilder)builder).setAttributesAdvice(Arrays.asList(SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_SCHEME, SemanticAttributes.NET_HOST_NAME, SemanticAttributes.NET_HOST_PORT, SemanticAttributes.HTTP_REQUEST_METHOD, SemanticAttributes.URL_SCHEME));
    }

    private HttpMetricsAdvice() {
    }
}

