/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ClientSideServerPortCondition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpAddressPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientResendCount;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpNetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public final class HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;
    final HttpAddressPortExtractor<REQUEST> addressPortExtractor;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    ToIntFunction<Context> resendCountIncrementer = HttpClientResendCount::getAndIncrement;

    HttpClientAttributesExtractorBuilder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.netAttributesGetter = netAttributesGetter;
        this.addressPortExtractor = new HttpAddressPortExtractor<REQUEST>(httpAttributesGetter);
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = new ArrayList<String>(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = new ArrayList<String>(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setResendCountIncrementer(ToIntFunction<Context> resendCountIncrementer) {
        this.resendCountIncrementer = resendCountIncrementer;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpClientAttributesExtractor(this);
    }

    InternalNetClientAttributesExtractor<REQUEST, RESPONSE> buildNetExtractor() {
        return new InternalNetClientAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, this.addressPortExtractor, SemconvStability.emitOldHttpSemconv());
    }

    InternalNetworkAttributesExtractor<REQUEST, RESPONSE> buildNetworkExtractor() {
        return new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, HttpNetworkTransportFilter.INSTANCE, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }

    InternalServerAttributesExtractor<REQUEST, RESPONSE> buildServerExtractor() {
        return new InternalServerAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, new ClientSideServerPortCondition<REQUEST>(this.httpAttributesGetter), this.addressPortExtractor, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.PEER, true);
    }
}

