/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.NoopLoggerFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class InternalLogger {
    private static final AtomicReference<Factory> loggerFactory = new AtomicReference<Factory>(NoopLoggerFactory.INSTANCE);

    public static void initialize(Factory factory) {
        if (!loggerFactory.compareAndSet(NoopLoggerFactory.INSTANCE, factory)) {
            factory.create(InternalLogger.class.getName()).log(Level.WARN, "Developer error: logging system has already been initialized once", null);
        }
    }

    static InternalLogger getLogger(String name) {
        return loggerFactory.get().create(name);
    }

    protected abstract boolean isLoggable(Level var1);

    protected abstract void log(Level var1, String var2, @Nullable Throwable var3);

    protected abstract String name();

    @FunctionalInterface
    public static interface Factory {
        public InternalLogger create(String var1);
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

