/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> NetClientAttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new NetClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        String sockPeerAddr;
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.transport(request, response));
        String peerName = this.getter.peerName(request, response);
        Integer peerPort = this.getter.peerPort(request, response);
        if (peerName != null) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_NAME, peerName);
            if (peerPort != null && peerPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_PEER_PORT, Long.valueOf(peerPort.intValue()));
            }
        }
        if ((sockPeerAddr = this.getter.sockPeerAddr(request, response)) != null && !sockPeerAddr.equals(peerName)) {
            String sockPeerName;
            String sockFamily;
            AttributesExtractorUtil.internalSet(attributes, NetAttributes.NET_SOCK_PEER_ADDR, sockPeerAddr);
            Integer sockPeerPort = this.getter.sockPeerPort(request, response);
            if (sockPeerPort != null && sockPeerPort > 0 && !sockPeerPort.equals(peerPort)) {
                AttributesExtractorUtil.internalSet(attributes, NetAttributes.NET_SOCK_PEER_PORT, Long.valueOf(sockPeerPort.intValue()));
            }
            if ((sockFamily = this.getter.sockFamily(request, response)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet(attributes, NetAttributes.NET_SOCK_FAMILY, sockFamily);
            }
            if ((sockPeerName = this.getter.sockPeerName(request, response)) != null && !sockPeerName.equals(peerName)) {
                AttributesExtractorUtil.internalSet(attributes, NetAttributes.NET_SOCK_PEER_NAME, sockPeerName);
            }
        }
    }
}

