/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.async;

import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.async.AsyncSpanEndStrategy;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

enum Jdk8AsyncSpanEndStrategy implements AsyncSpanEndStrategy
{
    INSTANCE;


    @Override
    public boolean supports(Class<?> returnType) {
        return returnType == CompletionStage.class || returnType == CompletableFuture.class;
    }

    @Override
    public Object end(BaseTracer tracer, Context context, Object returnValue) {
        if (returnValue instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)returnValue;
            if (this.endSynchronously(future, tracer, context)) {
                return future;
            }
            return this.endWhenComplete(future, tracer, context);
        }
        CompletionStage stage = (CompletionStage)returnValue;
        return this.endWhenComplete(stage, tracer, context);
    }

    private boolean endSynchronously(CompletableFuture<?> future, BaseTracer tracer, Context context) {
        if (!future.isDone()) {
            return false;
        }
        if (future.isCompletedExceptionally()) {
            try {
                future.join();
            }
            catch (Exception exception) {
                tracer.endExceptionally(context, exception);
                return true;
            }
        }
        tracer.end(context);
        return true;
    }

    private CompletionStage<?> endWhenComplete(CompletionStage<?> stage, BaseTracer tracer, Context context) {
        return stage.whenComplete((result, exception) -> {
            if (exception != null) {
                tracer.endExceptionally(context, (Throwable)exception);
            } else {
                tracer.end(context);
            }
        });
    }
}

