/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.HttpAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;

final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor;

    protected HttpSpanStatusExtractor(HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public StatusCode extract(REQUEST request, RESPONSE response, Throwable error) {
        Long statusCode = this.attributesExtractor.statusCode(request, response);
        if (statusCode != null) {
            return HttpStatusConverter.statusFromHttpStatus((int)statusCode.longValue());
        }
        return SpanStatusExtractor.getDefault().extract(request, response, error);
    }
}

