/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.Utils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.spi.trace.TracerProviderFactory;
import java.util.Objects;

public final class DefaultOpenTelemetryBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    private TracerProvider tracerProvider;

    DefaultOpenTelemetryBuilder() {
    }

    public DefaultOpenTelemetryBuilder setTracerProvider(TracerProvider tracerProvider) {
        Objects.requireNonNull(tracerProvider, "tracerProvider");
        this.tracerProvider = tracerProvider;
        return this;
    }

    public DefaultOpenTelemetryBuilder setPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetry build() {
        TracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            TracerProviderFactory tracerProviderFactory = Utils.loadSpi(TracerProviderFactory.class);
            tracerProvider = tracerProviderFactory != null ? tracerProviderFactory.create() : TracerProvider.getDefault();
        }
        return new DefaultOpenTelemetry(tracerProvider, this.propagators);
    }
}

